/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger;

import com.strategicgains.restexpress.plugin.swagger.annotations.ApiModelProperty;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiModel;
import com.strategicgains.restexpress.plugin.swagger.domain.DataType;
import com.strategicgains.restexpress.plugin.swagger.domain.Items;
import com.strategicgains.restexpress.plugin.swagger.domain.Primitives;
import com.strategicgains.restexpress.plugin.swagger.utilities.SwaggerObjectConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModelResolver {
    private Map<String, ApiModel> models;

    public ModelResolver() {
        this(new HashMap<String, ApiModel>());
    }

    public ModelResolver(Map<String, ApiModel> models) {
        this.models = models;
    }

    public DataType resolve(Type cls) {
        return this.resolve(cls, null);
    }

    public DataType resolve(Type cls, String modelName) {
        return this.createNode(cls, modelName, null, null);
    }

    private ApiModel resolveClass(Class<?> target, String modelName) {
        String id = this.getModelId(target, modelName);
        ApiModel model = this.models.get(id);
        if (model != null) {
            return model;
        }
        if (target.isPrimitive()) {
            System.err.println("Unable to resolve primitive class: " + target);
            return model;
        }
        if (target.isSynthetic()) {
            System.err.println("Unable to resolve synthetic class: " + target);
            return model;
        }
        if (target.isArray()) {
            System.err.println("Unable to use arrays for models: " + target);
            return model;
        }
        model = new ApiModel().id(id);
        this.models.put(id, model);
        HashMap<String, DataType> properties = new HashMap<String, DataType>();
        for (Class<?> cls = target; !Object.class.equals(cls) && cls != null; cls = cls.getSuperclass()) {
            this.processFields(properties, cls, modelName);
        }
        ArrayList sorted = new ArrayList(properties.values());
        Collections.sort(sorted, new Comparator<DataType>(){

            @Override
            public int compare(DataType o1, DataType o2) {
                return o1.getPosition() - o2.getPosition();
            }
        });
        for (DataType property : sorted) {
            model.property(property);
            if (!property.isRequired()) continue;
            model.required(property.getProperty());
        }
        return model;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DataType createNode(Type target, String modelName, String dataType, String format) {
        DataType node = new DataType();
        if (dataType != null && !dataType.isEmpty()) {
            node.setType(dataType);
            if (format == null) return node;
            if (format.isEmpty()) return node;
            node.setFormat(format);
            return node;
        }
        if (target instanceof Class) {
            Class targetClass = (Class)target;
            if (String.class.equals((Object)target)) {
                node.setType(Primitives.STRING);
                return node;
            }
            if (Integer.class.equals((Object)target) || Integer.TYPE.equals(target)) {
                node.setType(Primitives.INTEGER);
                return node;
            }
            if (Short.class.equals((Object)target) || Short.TYPE.equals(target)) {
                node.setType(Primitives.INTEGER);
                return node;
            }
            if (Long.class.equals((Object)target) || Long.TYPE.equals(target)) {
                node.setType(Primitives.LONG);
                return node;
            }
            if (Boolean.class.equals((Object)target) || Boolean.TYPE.equals(target)) {
                node.setType(Primitives.BOOLEAN);
                return node;
            }
            if (Float.class.equals((Object)target) || Float.TYPE.equals(target)) {
                node.setType(Primitives.FLOAT);
                return node;
            }
            if (Double.class.equals((Object)target) || Double.TYPE.equals(target)) {
                node.setType(Primitives.DOUBLE);
                return node;
            }
            if (Byte.class.equals((Object)target) || Byte.TYPE.equals(target)) {
                node.setType(Primitives.BYTE);
                return node;
            }
            if (Date.class.equals((Object)target)) {
                node.setType(Primitives.DATE_TIME);
                return node;
            }
            if (targetClass.isArray()) {
                node.setType("array");
                DataType componentModel = this.createNode(targetClass.getComponentType(), null, null, null);
                node.setItems(new Items(componentModel));
                return node;
            }
            if (Map.class.isAssignableFrom(targetClass)) {
                node.setType("object");
                return node;
            }
            if (targetClass.isEnum()) {
                node.setType(Primitives.STRING);
                T[] componentModel = targetClass.getEnumConstants();
                int n = componentModel.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = componentModel[n2];
                    node.addEnum(obj.toString());
                    ++n2;
                }
                return node;
            }
            if (Void.class.equals((Object)target) || Void.TYPE.equals(target)) {
                node.setType(Primitives.VOID);
                return node;
            }
            if (targetClass.getSimpleName().equals("ObjectId")) {
                node.setType(Primitives.STRING);
                return node;
            }
            ApiModel subModel = this.resolveClass(targetClass, modelName);
            node.setRef(subModel.getId());
            return node;
        }
        if (!(target instanceof ParameterizedType)) {
            System.err.println("Unhandled type: " + target);
            return node;
        }
        ParameterizedType parameterizedType = (ParameterizedType)target;
        Class rawType = (Class)parameterizedType.getRawType();
        if (Map.class.isAssignableFrom(rawType)) {
            node.setType("object");
        }
        if (!Collection.class.isAssignableFrom(rawType)) {
            System.err.println("Unhandled generic type: " + target);
            return node;
        }
        node.setType("array");
        if (Set.class.isAssignableFrom(rawType)) {
            node.setUniqueItems(true);
        }
        DataType componentModel = this.createNode(parameterizedType.getActualTypeArguments()[0], null, null, null);
        node.setItems(new Items(componentModel));
        return node;
    }

    private void processFields(Map<String, DataType> properties, Class<?> target, String modelName) {
        for (Field field : target.getDeclaredFields()) {
            DataType property;
            PropertyMetadata propertyMetadata;
            if ((field.getModifiers() & 0x88) != 0 || (propertyMetadata = this.getPropertyMetadataFromField(field)) != null && propertyMetadata.hidden) continue;
            if (propertyMetadata != null && propertyMetadata.excludeFromModels != null) {
                String modelId = this.getModelId(target, modelName);
                if (Arrays.asList(propertyMetadata.excludeFromModels).contains(modelId)) continue;
            }
            if (propertyMetadata == null) {
                property = this.createNode(field.getGenericType(), null, null, null).setProperty(field.getName());
                properties.put(field.getName(), property);
                continue;
            }
            if (!properties.containsKey(field.getName())) {
                property = this.createNode(field.getGenericType(), null, propertyMetadata.dataType, propertyMetadata.format).setDescription(propertyMetadata.notes).setRequired(propertyMetadata.required).setPosition(propertyMetadata.position).setDefaultValue(propertyMetadata.defaultValue).setProperty(field.getName());
                properties.put(field.getName(), property);
                continue;
            }
            property = this.createNode(field.getGenericType(), null, propertyMetadata.dataType, propertyMetadata.format).setProperty(field.getName());
            properties.put(field.getName(), property);
        }
    }

    private String getModelId(Class<?> target, String modelName) {
        String id = null;
        id = modelName != null && !modelName.isEmpty() ? modelName : target.getSimpleName();
        return id;
    }

    private PropertyMetadata getPropertyMetadataFromField(Field field) {
        PropertyMetadata propertyMetadata = null;
        if (field != null) {
            for (Annotation a : field.getAnnotations()) {
                if (a instanceof ApiModelProperty) {
                    ApiModelProperty model = (ApiModelProperty)a;
                    propertyMetadata = new PropertyMetadata();
                    propertyMetadata.allowableValues = model.allowableValues();
                    propertyMetadata.access = model.access();
                    propertyMetadata.notes = model.notes();
                    propertyMetadata.dataType = model.dataType();
                    propertyMetadata.format = model.format();
                    propertyMetadata.required = model.required();
                    propertyMetadata.position = model.position();
                    propertyMetadata.hidden = model.hidden();
                    propertyMetadata.excludeFromModels = model.excludeFromModels();
                    if (model.defaultValue() == null || model.defaultValue() == "") break;
                    try {
                        if (field.getType().isArray()) {
                            propertyMetadata.defaultValue = SwaggerObjectConverter.convertObjectTo(model.defaultValue(), field.getType().getComponentType());
                            break;
                        }
                        propertyMetadata.defaultValue = SwaggerObjectConverter.convertObjectTo(model.defaultValue(), field.getType());
                    }
                    catch (Exception exception) {}
                    break;
                }
                if (!(a instanceof com.wordnik.swagger.annotations.ApiModelProperty)) continue;
                com.wordnik.swagger.annotations.ApiModelProperty model = (com.wordnik.swagger.annotations.ApiModelProperty)a;
                propertyMetadata = new PropertyMetadata();
                propertyMetadata.value = model.value();
                propertyMetadata.allowableValues = model.allowableValues();
                propertyMetadata.access = model.access();
                propertyMetadata.notes = model.notes();
                propertyMetadata.dataType = model.dataType();
                propertyMetadata.required = model.required();
                propertyMetadata.position = model.position();
                propertyMetadata.hidden = model.hidden();
                break;
            }
        }
        return propertyMetadata;
    }

    private class PropertyMetadata {
        String value = "";
        String allowableValues = "";
        String access = "";
        String notes = "";
        String dataType = "";
        String format = "";
        boolean required = false;
        int position = 0;
        boolean hidden = false;
        String[] excludeFromModels = new String[0];
        Object defaultValue = null;

        private PropertyMetadata() {
        }
    }
}

