/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger;

import com.strategicgains.restexpress.plugin.swagger.domain.ApiDeclarations;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiOperation;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiResources;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.RestExpress;
import org.restexpress.exception.NotFoundException;
import org.restexpress.route.Route;
import org.restexpress.route.RouteBuilder;
import org.restexpress.util.Callback;

public class SwaggerController
implements Callback<RouteBuilder> {
    public static final List<String> VALID_METHODS = new ArrayList<String>(Arrays.asList("GET", "PUT", "POST", "DELETE", "HEAD", "PATCH"));
    private boolean shouldShowAnnotatedOnly = false;
    private RestExpress server;
    private ApiResources resources;
    private Map<String, ApiDeclarations> apisByPath = new HashMap<String, ApiDeclarations>();
    private String swaggerRoot;

    public SwaggerController(RestExpress server, String apiVersion, String swaggerVersion, boolean shouldShowAnnotatedOnly) {
        this(server, apiVersion, swaggerVersion);
        this.shouldShowAnnotatedOnly = shouldShowAnnotatedOnly;
    }

    public SwaggerController(RestExpress server, String apiVersion, String swaggerVersion) {
        this.resources = new ApiResources(apiVersion, swaggerVersion);
        this.server = server;
    }

    public void initialize(String urlPath, RestExpress server) {
        this.swaggerRoot = this.getPathSegment(urlPath);
        server.iterateRouteBuilders((Callback)this);
    }

    public ApiResources readAll(Request request, Response response) {
        return this.resources;
    }

    public ApiDeclarations read(Request request, Response response) {
        String path = request.getHeader("path");
        ApiDeclarations api = this.apisByPath.get("/" + path);
        if (api == null) {
            throw new NotFoundException(path);
        }
        if (!api.hasBasePath()) {
            ApiDeclarations apid = new ApiDeclarations(api);
            apid.setBasePath(request.getBaseUrl());
            return apid;
        }
        return api;
    }

    private String getPathSegment(String pattern) {
        int slash = pattern.indexOf(47, 1);
        int dot = pattern.indexOf(46, 1);
        String path = slash > 0 ? pattern.substring(0, slash) : (dot > 0 ? pattern.substring(0, dot) : pattern);
        return path;
    }

    public void process(RouteBuilder routeBuilder) {
        for (Route route : routeBuilder.build()) {
            String path;
            if (!VALID_METHODS.contains(route.getMethod().name()) || this.swaggerRoot.equals(path = this.getPathSegment(route.getPattern())) || "/".equals(path) || this.isRouteHidden(route)) continue;
            ApiDeclarations apis = this.apisByPath.get(path);
            if (apis == null) {
                apis = new ApiDeclarations(this.resources, this.server, path);
                this.apisByPath.put(path, apis);
                this.resources.addApi(path, null);
            }
            ApiOperation operation = apis.addOperation(route);
            apis.addModels(operation, route);
        }
    }

    private boolean isRouteHidden(Route route) {
        Method method = route.getAction();
        if (method.isAnnotationPresent(com.wordnik.swagger.annotations.ApiOperation.class)) {
            com.wordnik.swagger.annotations.ApiOperation annotation = method.getAnnotation(com.wordnik.swagger.annotations.ApiOperation.class);
            return annotation.hidden();
        }
        return this.shouldShowAnnotatedOnly;
    }
}

