/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger.domain;

import com.strategicgains.restexpress.plugin.swagger.domain.ApiOperation;
import com.strategicgains.restexpress.plugin.swagger.domain.Authorization;
import com.strategicgains.restexpress.plugin.swagger.domain.Authorizations;
import java.util.ArrayList;
import java.util.List;
import org.restexpress.route.Route;

public class ApiDeclaration {
    private String path;
    private String description;
    private List<String> consumes;
    private List<String> produces;
    private Authorizations authorizations;
    private List<ApiOperation> operations = new ArrayList<ApiOperation>();

    public ApiDeclaration(Route route) {
        this.path = route.getPattern();
        this.description = route.getName();
    }

    public ApiDeclaration(String path, String description) {
        this.path = path;
        this.description = description;
    }

    public ApiDeclaration operation(ApiOperation operation) {
        this.operations.add(operation);
        return this;
    }

    public ApiDeclaration authorization(String key, Authorization authn) {
        if (this.authorizations == null) {
            this.authorizations = new Authorizations();
        }
        this.authorizations.put(key, authn);
        return this;
    }

    public ApiDeclaration consumes(String contentType) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        if (!this.consumes.contains(contentType)) {
            this.consumes.add(contentType);
        }
        return this;
    }

    public ApiDeclaration produces(String contentType) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        if (!this.produces.contains(contentType)) {
            this.produces.add(contentType);
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }
}

