/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.adapter;

import com.strategicgains.repoexpress.adapter.IdentifierAdapter;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.exception.InvalidObjectIdException;
import com.strategicgains.repoexpress.util.UuidConverter;
import java.util.UUID;

public class UuidAdapter
implements IdentifierAdapter {
    private boolean shouldShorten = false;

    public void useShortUUID(boolean value) {
        this.shouldShorten = value;
    }

    @Override
    public Identifier parse(String id) throws InvalidObjectIdException {
        if (id == null || id.isEmpty()) {
            throw new InvalidObjectIdException("Identifier must not be null");
        }
        try {
            return new Identifier(UuidConverter.parse(id));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidObjectIdException(e);
        }
    }

    @Override
    public String format(Identifier id) {
        return this.format(id, this.shouldShorten);
    }

    public String format(Identifier id, boolean shorten) {
        if (id == null) {
            return null;
        }
        return this.format((UUID)id.primaryKey(), shorten);
    }

    public String format(UUID uuid) {
        return this.format(uuid, this.shouldShorten);
    }

    public String format(UUID uuid, boolean shorten) {
        if (shorten) {
            return uuid == null ? null : UuidConverter.format(uuid);
        }
        return uuid == null ? null : uuid.toString();
    }
}

