/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.event;

import com.strategicgains.repoexpress.domain.UuidIdentifiable;
import com.strategicgains.repoexpress.event.AbstractRepositoryObserver;
import com.strategicgains.repoexpress.exception.InvalidObjectIdException;
import java.util.UUID;

public class UuidIdentityRepositoryObserver<T extends UuidIdentifiable>
extends AbstractRepositoryObserver<T> {
    @Override
    public void beforeCreate(T object) {
        super.beforeCreate(object);
        if (object.getUuid() == null) {
            object.setUuid(UUID.randomUUID());
        }
    }

    @Override
    public void beforeUpdate(T object) {
        if (object.getUuid() == null) {
            throw new InvalidObjectIdException("UUID required on update");
        }
    }
}

