/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.mongodb;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.strategicgains.repoexpress.AbstractObservableRepository;
import com.strategicgains.repoexpress.Queryable;
import com.strategicgains.repoexpress.domain.Identifiable;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.exception.DuplicateItemException;
import com.strategicgains.repoexpress.exception.InvalidObjectIdException;
import com.strategicgains.repoexpress.exception.ItemNotFoundException;
import java.util.Collection;
import java.util.List;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.Query;
import org.restexpress.common.query.FilterCallback;
import org.restexpress.common.query.FilterComponent;
import org.restexpress.common.query.OrderCallback;
import org.restexpress.common.query.OrderComponent;
import org.restexpress.common.query.QueryFilter;
import org.restexpress.common.query.QueryOrder;
import org.restexpress.common.query.QueryRange;

public class MongodbRepository<T extends Identifiable>
extends AbstractObservableRepository<T>
implements Queryable<T> {
    private MongoClient mongo;
    private Morphia morphia;
    private Datastore datastore;
    private Class<T> inheritanceRoot;

    public MongodbRepository(MongoClient mongo, String dbName, Class<? extends T> ... entityClasses) {
        this.mongo = mongo;
        this.initialize(dbName, entityClasses);
    }

    private void initialize(String name, Class<? extends T> ... entityClasses) {
        this.morphia = new Morphia();
        this.inheritanceRoot = entityClasses[0];
        for (Class<? extends T> entityClass : entityClasses) {
            this.morphia.map(new Class[]{entityClass});
        }
        this.datastore = this.morphia.createDatastore(this.mongo, name);
        this.datastore.ensureIndexes();
        this.datastore.ensureCaps();
    }

    public T doCreate(T item) {
        if (this.exists(item.getId())) {
            throw new DuplicateItemException(item.getClass().getSimpleName() + " ID already exists: " + item.getId());
        }
        this.datastore.save(item);
        return item;
    }

    public T doRead(Identifier id) {
        Identifiable item = (Identifiable)this.datastore.get(this.inheritanceRoot, id.primaryKey());
        if (item == null) {
            throw new ItemNotFoundException("ID not found: " + id);
        }
        return (T)item;
    }

    public T doUpdate(T item) {
        if (!this.exists(item.getId())) {
            throw new ItemNotFoundException(item.getClass().getSimpleName() + " ID not found: " + item.getId());
        }
        this.datastore.save(item);
        return item;
    }

    public void doDelete(T object) {
        try {
            this.datastore.delete(object);
        }
        catch (InvalidObjectIdException e) {
            throw new ItemNotFoundException("ID not found: " + object.getId());
        }
    }

    public List<T> find(QueryFilter filter) {
        return this.readAll(filter, null, null);
    }

    public List<T> readAll(QueryFilter filter, QueryRange range, QueryOrder order) {
        return this.query(this.inheritanceRoot, filter, range, order);
    }

    public List<T> readList(Collection<Identifier> ids) {
        return ((Query)this.getDataStore().find(this.inheritanceRoot).field("_id").in((Iterable)new AbstractObservableRepository.PrimaryIdIterable((AbstractObservableRepository)this, ids))).asList();
    }

    public long count(QueryFilter filter) {
        return this.count(this.inheritanceRoot, filter);
    }

    public long count(Class<T> type, QueryFilter filter) {
        return this.getBaseFilterQuery(type, filter).countAll();
    }

    public boolean exists(Identifier id) {
        if (id == null) {
            return false;
        }
        return this.datastore.getCount(this.datastore.find(this.inheritanceRoot, "_id", id.primaryKey())) > 0L;
    }

    protected Datastore getDataStore() {
        return this.datastore;
    }

    protected Mongo getMongo() {
        return this.mongo;
    }

    protected List<T> query(Class<T> type, QueryFilter filter, QueryRange range, QueryOrder order) {
        return this.getBaseQuery(type, filter, range, order).asList();
    }

    protected Query<T> getBaseQuery(Class<T> type, QueryFilter filter, QueryRange range, QueryOrder order) {
        Query<T> q = this.getBaseFilterQuery(type, filter);
        this.configureQueryRange(q, range);
        this.configureQueryOrder(q, order);
        return q;
    }

    private Query<T> getBaseFilterQuery(Class<T> type, QueryFilter filter) {
        Query q = this.getDataStore().find(type);
        this.configureQueryFilter(q, filter);
        return q;
    }

    private void configureQueryRange(Query<T> q, QueryRange range) {
        if (range == null) {
            return;
        }
        if (range.isInitialized()) {
            q.offset((int)range.getStart());
            q.limit(range.getLimit());
        }
    }

    private void configureQueryFilter(final Query<T> q, QueryFilter filter) {
        if (filter == null) {
            return;
        }
        filter.iterate(new FilterCallback(){

            public void filterOn(FilterComponent c) {
                switch (c.getOperator()) {
                    case CONTAINS: {
                        q.field(c.getField()).contains(c.getValue().toString());
                        break;
                    }
                    case STARTS_WITH: {
                        q.field(c.getField()).startsWith(c.getValue().toString());
                        break;
                    }
                    case GREATER_THAN: {
                        q.field(c.getField()).greaterThan(c.getValue());
                        break;
                    }
                    case GREATER_THAN_OR_EQUAL_TO: {
                        q.field(c.getField()).greaterThanOrEq(c.getValue());
                        break;
                    }
                    case LESS_THAN: {
                        q.field(c.getField()).lessThan(c.getValue());
                        break;
                    }
                    case LESS_THAN_OR_EQUAL_TO: {
                        q.field(c.getField()).lessThanOrEq(c.getValue());
                        break;
                    }
                    case NOT_EQUALS: {
                        q.field(c.getField()).notEqual(c.getValue());
                        break;
                    }
                    case IN: {
                        q.field(c.getField()).in((Iterable)c.getValue());
                        break;
                    }
                    default: {
                        q.field(c.getField()).equal(c.getValue());
                    }
                }
            }
        });
    }

    private void configureQueryOrder(Query<T> q, QueryOrder order) {
        if (order == null) {
            return;
        }
        if (order.isSorted()) {
            final StringBuilder sb = new StringBuilder();
            order.iterate(new OrderCallback(){
                boolean isFirst = true;

                public void orderBy(OrderComponent component) {
                    if (!this.isFirst) {
                        sb.append(',');
                    }
                    if (component.isDescending()) {
                        sb.append('-');
                    }
                    sb.append(component.getFieldName());
                    this.isFirst = false;
                }
            });
            q.order(sb.toString());
        }
    }
}

