/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.mongodb;

import com.strategicgains.repoexpress.adapter.IdentifierAdapter;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.exception.InvalidObjectIdException;
import org.bson.types.ObjectId;

public class ObjectIdAdapter
implements IdentifierAdapter {
    public Identifier parse(String id) throws InvalidObjectIdException {
        if (id == null || id.isEmpty()) {
            throw new InvalidObjectIdException("null ID");
        }
        if (ObjectId.isValid((String)id)) {
            return new Identifier(new Object[]{new ObjectId(id)});
        }
        throw new InvalidObjectIdException(id);
    }

    public String format(Identifier id) {
        return id == null ? null : id.primaryKey().toString();
    }
}

