/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.InvoiceRenderingTemplateCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.InvoiceRenderingTemplateArchiveParams;
import com.stripe.param.InvoiceRenderingTemplateListParams;
import com.stripe.param.InvoiceRenderingTemplateRetrieveParams;
import com.stripe.param.InvoiceRenderingTemplateUnarchiveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class InvoiceRenderingTemplate
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="nickname")
    String nickname;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="version")
    Long version;

    public InvoiceRenderingTemplate archive() throws StripeException {
        return this.archive((Map<String, Object>)null, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate archive(RequestOptions options) throws StripeException {
        return this.archive((Map<String, Object>)null, options);
    }

    public InvoiceRenderingTemplate archive(Map<String, Object> params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate archive(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (InvoiceRenderingTemplate)this.getResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public InvoiceRenderingTemplate archive(InvoiceRenderingTemplateArchiveParams params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate archive(InvoiceRenderingTemplateArchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)this.getResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public static InvoiceRenderingTemplateCollection list(Map<String, Object> params) throws StripeException {
        return InvoiceRenderingTemplate.list(params, (RequestOptions)null);
    }

    public static InvoiceRenderingTemplateCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/invoice_rendering_templates";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (InvoiceRenderingTemplateCollection)InvoiceRenderingTemplate.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplateCollection.class));
    }

    public static InvoiceRenderingTemplateCollection list(InvoiceRenderingTemplateListParams params) throws StripeException {
        return InvoiceRenderingTemplate.list(params, (RequestOptions)null);
    }

    public static InvoiceRenderingTemplateCollection list(InvoiceRenderingTemplateListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoice_rendering_templates";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplateCollection)InvoiceRenderingTemplate.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplateCollection.class));
    }

    public static InvoiceRenderingTemplate retrieve(String template) throws StripeException {
        return InvoiceRenderingTemplate.retrieve(template, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static InvoiceRenderingTemplate retrieve(String template, RequestOptions options) throws StripeException {
        return InvoiceRenderingTemplate.retrieve(template, (Map<String, Object>)null, options);
    }

    public static InvoiceRenderingTemplate retrieve(String template, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s", ApiResource.urlEncodeId(template));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (InvoiceRenderingTemplate)InvoiceRenderingTemplate.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public static InvoiceRenderingTemplate retrieve(String template, InvoiceRenderingTemplateRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s", ApiResource.urlEncodeId(template));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)InvoiceRenderingTemplate.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public InvoiceRenderingTemplate unarchive() throws StripeException {
        return this.unarchive((Map<String, Object>)null, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate unarchive(RequestOptions options) throws StripeException {
        return this.unarchive((Map<String, Object>)null, options);
    }

    public InvoiceRenderingTemplate unarchive(Map<String, Object> params) throws StripeException {
        return this.unarchive(params, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate unarchive(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/unarchive", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (InvoiceRenderingTemplate)this.getResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    public InvoiceRenderingTemplate unarchive(InvoiceRenderingTemplateUnarchiveParams params) throws StripeException {
        return this.unarchive(params, (RequestOptions)null);
    }

    public InvoiceRenderingTemplate unarchive(InvoiceRenderingTemplateUnarchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoice_rendering_templates/%s/unarchive", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceRenderingTemplate)this.getResponseGetter().request(request, (Type)((Object)InvoiceRenderingTemplate.class));
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getNickname() {
        return this.nickname;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceRenderingTemplate)) {
            return false;
        }
        InvoiceRenderingTemplate other = (InvoiceRenderingTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$nickname = this.getNickname();
        String other$nickname = other.getNickname();
        if (this$nickname == null ? other$nickname != null : !this$nickname.equals(other$nickname)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceRenderingTemplate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $nickname = this.getNickname();
        result = result * 59 + ($nickname == null ? 43 : $nickname.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

