/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.model.HasId;
import com.stripe.model.PagingIterable;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.model.StripeObject;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class StripeCollection<T extends HasId>
extends StripeObject
implements StripeCollectionInterface<T>,
StripeActiveObject {
    private transient StripeResponseGetter responseGetter;
    String object;
    List<T> data;
    Boolean hasMore;
    String url;
    private transient RequestOptions requestOptions;
    private Map<String, Object> requestParams;
    private transient Type pageTypeToken;

    public Iterable<T> autoPagingIterable() {
        this.responseGetter.validateRequestOptions(this.requestOptions);
        return new PagingIterable(this, this.responseGetter, this.pageTypeToken);
    }

    public Iterable<T> autoPagingIterable(Map<String, Object> params) {
        this.responseGetter.validateRequestOptions(this.requestOptions);
        this.setRequestParams(params);
        return new PagingIterable(this, this.responseGetter, this.pageTypeToken);
    }

    public Iterable<T> autoPagingIterable(Map<String, Object> params, RequestOptions options) {
        this.responseGetter.validateRequestOptions(options);
        this.setRequestOptions(options);
        this.setRequestParams(params);
        return new PagingIterable(this, this.responseGetter, this.pageTypeToken);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        this.responseGetter = responseGetter;
        if (this.data != null) {
            for (HasId item : this.data) {
                this.trySetResponseGetter(item, responseGetter);
            }
        }
    }

    @Generated
    public StripeResponseGetter getResponseGetter() {
        return this.responseGetter;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Type getPageTypeToken() {
        return this.pageTypeToken;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setData(List<T> data) {
        this.data = data;
    }

    @Generated
    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeCollection)) {
            return false;
        }
        StripeCollection other = (StripeCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hasMore = this.getHasMore();
        Boolean other$hasMore = other.getHasMore();
        if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, Object> this$requestParams = this.getRequestParams();
        Map<String, Object> other$requestParams = other.getRequestParams();
        return !(this$requestParams == null ? other$requestParams != null : !((Object)this$requestParams).equals(other$requestParams));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StripeCollection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasMore = this.getHasMore();
        result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, Object> $requestParams = this.getRequestParams();
        result = result * 59 + ($requestParams == null ? 43 : ((Object)$requestParams).hashCode());
        return result;
    }

    @Override
    @Generated
    public List<T> getData() {
        return this.data;
    }

    @Override
    @Generated
    public Boolean getHasMore() {
        return this.hasMore;
    }

    @Override
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    @Override
    @Generated
    public void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    @Override
    @Generated
    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }

    @Override
    @Generated
    public void setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
    }

    @Override
    @Generated
    public void setPageTypeToken(Type pageTypeToken) {
        this.pageTypeToken = pageTypeToken;
    }
}

