/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.treasury;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.treasury.CreditReversal;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.treasury.CreditReversalCreateParams;
import com.stripe.param.treasury.CreditReversalListParams;
import com.stripe.param.treasury.CreditReversalRetrieveParams;
import java.lang.reflect.Type;

public final class CreditReversalService
extends ApiService {
    public CreditReversalService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CreditReversal> list(CreditReversalListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CreditReversal> list(CreditReversalListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/credit_reversals";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<CreditReversal>>(){}.getType());
    }

    public CreditReversal create(CreditReversalCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public CreditReversal create(CreditReversalCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/treasury/credit_reversals";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditReversal)this.request(request, (Type)((Object)CreditReversal.class));
    }

    public CreditReversal retrieve(String creditReversal, CreditReversalRetrieveParams params) throws StripeException {
        return this.retrieve(creditReversal, params, null);
    }

    public CreditReversal retrieve(String creditReversal, RequestOptions options) throws StripeException {
        return this.retrieve(creditReversal, null, options);
    }

    public CreditReversal retrieve(String creditReversal) throws StripeException {
        return this.retrieve(creditReversal, null, null);
    }

    public CreditReversal retrieve(String creditReversal, CreditReversalRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/treasury/credit_reversals/%s", ApiResource.urlEncodeId(creditReversal));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditReversal)this.request(request, (Type)((Object)CreditReversal.class));
    }
}

