/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.util;

import java.time.Duration;

public class Stopwatch {
    private long elapsed;
    private boolean running;
    private long startTimeStamp;

    public Stopwatch() {
        this.reset();
    }

    public void start() {
        if (!this.running) {
            this.startTimeStamp = Stopwatch.getTimestamp();
            this.running = true;
        }
    }

    public static Stopwatch startNew() {
        Stopwatch s = new Stopwatch();
        s.start();
        return s;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        long endTimeStamp = Stopwatch.getTimestamp();
        long elapsedThisPeriod = endTimeStamp - this.startTimeStamp;
        this.elapsed += elapsedThisPeriod;
        this.running = false;
    }

    public void reset() {
        this.elapsed = 0L;
        this.running = false;
        this.startTimeStamp = 0L;
    }

    public void restart() {
        this.elapsed = 0L;
        this.running = true;
        this.startTimeStamp = Stopwatch.getTimestamp();
    }

    public boolean isRunning() {
        return this.running;
    }

    public Duration getElapsed() {
        return Duration.ofNanos(this.getRawElapsed());
    }

    public static long getTimestamp() {
        return System.nanoTime();
    }

    private long getRawElapsed() {
        long timeElapsed = this.elapsed;
        if (this.running) {
            long currentTimeStamp = Stopwatch.getTimestamp();
            long elapsedUntilNow = currentTimeStamp - this.startTimeStamp;
            timeElapsed += elapsedUntilNow;
        }
        return timeElapsed;
    }
}

