/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ReferencedTypesSupportingTypesStrategy
extends SupportingTypesStrategy {
    private boolean includeIndirectlyReferencedTypes;

    public ReferencedTypesSupportingTypesStrategy() {
        this(true);
    }

    public ReferencedTypesSupportingTypesStrategy(boolean includeIndirectlyReferencedTypes) {
        this.includeIndirectlyReferencedTypes = includeIndirectlyReferencedTypes;
    }

    private Set<Class<?>> getReferencedTypesInPackage(String type) {
        return this.getTypeRepository().findReferencedTypes(type).stream().filter(this::accepts).collect(Collectors.toSet());
    }

    private boolean accepts(Class<?> clazz) {
        String type = clazz.getCanonicalName();
        if (type != null) {
            for (String packageName : this.getTypeRepository().getPackages()) {
                if (!type.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Class<?>> findSupportingTypes(Component component) {
        HashSet referencedTypes = new HashSet();
        referencedTypes.addAll(this.getReferencedTypesInPackage(component.getType().getType()));
        for (CodeElement codeElement : component.getCode()) {
            referencedTypes.addAll(this.getReferencedTypesInPackage(codeElement.getType()));
        }
        if (this.includeIndirectlyReferencedTypes) {
            int numberOfTypes = referencedTypes.size();
            boolean foundMore = true;
            while (foundMore) {
                HashSet indirectlyReferencedTypes = new HashSet();
                for (Class clazz : referencedTypes) {
                    indirectlyReferencedTypes.addAll(this.getReferencedTypesInPackage(clazz.getCanonicalName()));
                }
                referencedTypes.addAll(indirectlyReferencedTypes);
                if (referencedTypes.size() > numberOfTypes) {
                    foundMore = true;
                    numberOfTypes = referencedTypes.size();
                    continue;
                }
                foundMore = false;
            }
        }
        return referencedTypes;
    }
}

