/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.TypeCategory;
import com.structurizr.analysis.TypeRepository;
import com.structurizr.analysis.TypeVisibility;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeUtils {
    private static final Log log = LogFactory.getLog(TypeUtils.class);

    public static TypeVisibility getVisibility(TypeRepository typeRepository, String typeName) {
        try {
            Class<?> type = typeRepository.loadClass(typeName);
            int modifiers = type.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                return TypeVisibility.PRIVATE;
            }
            if (Modifier.isPublic(modifiers)) {
                return TypeVisibility.PUBLIC;
            }
            if (Modifier.isProtected(modifiers)) {
                return TypeVisibility.PROTECTED;
            }
            return TypeVisibility.PACKAGE;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Visibility for type " + typeName + " could not be found."));
            return null;
        }
    }

    public static TypeCategory getCategory(TypeRepository typeRepository, String typeName) {
        try {
            Class<?> type = typeRepository.loadClass(typeName);
            if (type.isInterface()) {
                return TypeCategory.INTERFACE;
            }
            if (type.isEnum()) {
                return TypeCategory.ENUM;
            }
            if (Modifier.isAbstract(type.getModifiers())) {
                return TypeCategory.ABSTRACT_CLASS;
            }
            return TypeCategory.CLASS;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Category for type " + typeName + " could not be found."));
            return null;
        }
    }

    public static Set<Class<?>> findTypesAnnotatedWith(Class<? extends Annotation> annotation, Set<Class<?>> types) {
        if (annotation == null) {
            throw new IllegalArgumentException("An annotation type must be specified.");
        }
        return types.stream().filter(c -> c.isAnnotationPresent(annotation)).collect(Collectors.toSet());
    }

    public static Class findFirstImplementationOfInterface(Class interfaceType, Set<Class<?>> types) {
        if (interfaceType == null) {
            throw new IllegalArgumentException("An interface type must be provided.");
        }
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException("The interface type must represent an interface.");
        }
        if (types == null) {
            throw new IllegalArgumentException("The set of types to search through must be provided.");
        }
        for (Class<?> type : types) {
            boolean isInterface = type.isInterface();
            boolean isAbstract = Modifier.isAbstract(type.getModifiers());
            boolean isAssignable = interfaceType.isAssignableFrom(type);
            if (isInterface || isAbstract || !isAssignable) continue;
            return type;
        }
        return null;
    }
}

