/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import javax.annotation.Nonnull;

public final class DeploymentView
extends View {
    private Model model;
    private String environment;

    DeploymentView() {
    }

    DeploymentView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
    }

    DeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.model = softwareSystem.getModel();
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public void addAllDeploymentNodes() {
        this.getModel().getDeploymentNodes().forEach(this::add);
    }

    public void add(@Nonnull DeploymentNode deploymentNode) {
        if (deploymentNode == null) {
            throw new IllegalArgumentException("A deployment node must be specified.");
        }
        if (this.addContainerInstancesAndDeploymentNodes(deploymentNode)) {
            for (Element parent = deploymentNode.getParent(); parent != null; parent = parent.getParent()) {
                this.addElement(parent, false);
            }
        }
    }

    private boolean addContainerInstancesAndDeploymentNodes(DeploymentNode deploymentNode) {
        boolean hasContainers = false;
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            Container container = containerInstance.getContainer();
            if (this.getSoftwareSystem() != null && !container.getParent().equals(this.getSoftwareSystem())) continue;
            this.addElement(containerInstance, true);
            hasContainers = true;
        }
        for (DeploymentNode child : deploymentNode.getChildren()) {
            hasContainers |= this.addContainerInstancesAndDeploymentNodes(child);
        }
        if (hasContainers) {
            this.addElement(deploymentNode, false);
        }
        return hasContainers;
    }

    public RelationshipView add(@Nonnull Relationship relationship) {
        return this.addRelationship(relationship);
    }

    @Override
    public String getName() {
        String name = this.getSoftwareSystem() != null ? this.getSoftwareSystem().getName() + " - Deployment" : "Deployment";
        if (!StringUtils.isNullOrEmpty(this.getEnvironment())) {
            name = name + " - " + this.getEnvironment();
        }
        return name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }
}

