/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SequenceNumber;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;

public final class DynamicView
extends View {
    private Model model;
    private Element element;
    private String elementId;
    private SequenceNumber sequenceNumber = new SequenceNumber();

    DynamicView() {
    }

    DynamicView(Model model, String key, String description) {
        super(null, key, description);
        this.setModel(model);
        this.setElement(null);
    }

    DynamicView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.setModel(softwareSystem.getModel());
        this.setElement(softwareSystem);
    }

    DynamicView(Container container, String key, String description) {
        super(container.getSoftwareSystem(), key, description);
        this.setModel(container.getModel());
        this.setElement(container);
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    @JsonIgnore
    public String getSoftwareSystemId() {
        return super.getSoftwareSystemId();
    }

    public String getElementId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return this.elementId;
    }

    void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @JsonIgnore
    public Element getElement() {
        return this.element;
    }

    void setElement(Element element) {
        this.element = element;
        if (element instanceof SoftwareSystem) {
            this.setSoftwareSystem((SoftwareSystem)element);
        }
    }

    public RelationshipView add(@Nonnull Element source, @Nonnull Element destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(@Nonnull Element source, String description, @Nonnull Element destination) {
        if (source == null) {
            throw new IllegalArgumentException("A source element must be specified.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("A destination element must be specified.");
        }
        this.checkElement(source);
        this.checkElement(destination);
        Relationship relationship = source.getEfferentRelationshipWith(destination);
        if (relationship != null) {
            this.addElement(source, false);
            this.addElement(destination, false);
            return this.addRelationship(relationship, description, this.sequenceNumber.getNext());
        }
        throw new IllegalArgumentException("A relationship between " + source.getName() + " and " + destination.getName() + " does not exist in model.");
    }

    private void checkElement(Element elementToBeAdded) {
        if (!(elementToBeAdded instanceof Person || elementToBeAdded instanceof SoftwareSystem || elementToBeAdded instanceof Container || elementToBeAdded instanceof Component)) {
            throw new IllegalArgumentException("Only people, software systems, containers and components can be added to dynamic views.");
        }
        if (elementToBeAdded instanceof Person) {
            return;
        }
        if (this.element instanceof SoftwareSystem) {
            if (elementToBeAdded.equals(this.element)) {
                throw new IllegalArgumentException(elementToBeAdded.getName() + " is already the scope of this view and cannot be added to it.");
            }
            if (elementToBeAdded instanceof Container && !elementToBeAdded.getParent().equals(this.element)) {
                throw new IllegalArgumentException("Only containers that reside inside " + this.element.getName() + " can be added to this view.");
            }
            if (elementToBeAdded instanceof Component) {
                throw new IllegalArgumentException("Components can't be added to a dynamic view when the scope is a software system.");
            }
        }
        if (this.element instanceof Container) {
            if (elementToBeAdded.equals(this.element) || elementToBeAdded.equals(this.element.getParent())) {
                throw new IllegalArgumentException(elementToBeAdded.getName() + " is already the scope of this view and cannot be added to it.");
            }
            if (elementToBeAdded instanceof Container && !elementToBeAdded.getParent().equals(this.element.getParent())) {
                throw new IllegalArgumentException("Only containers that reside inside " + this.element.getParent().getName() + " can be added to this view.");
            }
            if (elementToBeAdded instanceof Component && !elementToBeAdded.getParent().equals(this.element)) {
                throw new IllegalArgumentException("Only components that reside inside " + this.element.getName() + " can be added to this view.");
            }
        }
        if (this.element == null && !(elementToBeAdded instanceof SoftwareSystem)) {
            throw new IllegalArgumentException("Only people and software systems can be added to this dynamic view.");
        }
    }

    @Override
    protected RelationshipView findRelationshipView(@Nonnull RelationshipView sourceRelationshipView) {
        for (RelationshipView relationshipView : this.getRelationships()) {
            if (!relationshipView.getRelationship().equals(sourceRelationshipView.getRelationship()) || relationshipView.getDescription() == null || !relationshipView.getDescription().equals(sourceRelationshipView.getDescription()) || !relationshipView.getOrder().equals(sourceRelationshipView.getOrder())) continue;
            return relationshipView;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.element != null) {
            return this.element.getName() + " - Dynamic";
        }
        return "Dynamic";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<RelationshipView> list = new ArrayList<RelationshipView>(this.getRelationships());
        Collections.sort(list, (rv1, rv2) -> rv1.getOrder().compareTo(rv2.getOrder()));
        list.forEach(rv -> buf.append(rv.toString() + "\n"));
        return buf.toString();
    }

    public void startParallelSequence() {
        this.sequenceNumber.startParallelSequence();
    }

    public void endParallelSequence() {
        this.endParallelSequence(false);
    }

    public void endParallelSequence(boolean endAllParallelSequencesAndContinueNumbering) {
        this.sequenceNumber.endParallelSequence(endAllParallelSequencesAndContinueNumbering);
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }
}

