/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Shape;
import java.util.Collection;
import java.util.LinkedList;

public final class Styles {
    private Collection<ElementStyle> elements = new LinkedList<ElementStyle>();
    private Collection<RelationshipStyle> relationships = new LinkedList<RelationshipStyle>();

    public Collection<ElementStyle> getElements() {
        return this.elements;
    }

    public void add(ElementStyle elementStyle) {
        if (elementStyle != null) {
            this.elements.add(elementStyle);
        }
    }

    public ElementStyle addElementStyle(String tag) {
        ElementStyle elementStyle = null;
        if (tag != null) {
            elementStyle = new ElementStyle();
            elementStyle.setTag(tag);
            this.add(elementStyle);
        }
        return elementStyle;
    }

    public Collection<RelationshipStyle> getRelationships() {
        return this.relationships;
    }

    public void add(RelationshipStyle relationshipStyle) {
        if (relationshipStyle != null) {
            this.relationships.add(relationshipStyle);
        }
    }

    public RelationshipStyle addRelationshipStyle(String tag) {
        RelationshipStyle relationshipStyle = null;
        if (tag != null) {
            relationshipStyle = new RelationshipStyle();
            relationshipStyle.setTag(tag);
            this.add(relationshipStyle);
        }
        return relationshipStyle;
    }

    private ElementStyle findElementStyle(String tag) {
        if (tag != null) {
            for (ElementStyle elementStyle : this.elements) {
                if (elementStyle == null || !elementStyle.getTag().equals(tag)) continue;
                return elementStyle;
            }
        }
        return null;
    }

    private RelationshipStyle findRelationshipStyle(String tag) {
        if (tag != null) {
            for (RelationshipStyle relationshipStyle : this.relationships) {
                if (relationshipStyle == null || !relationshipStyle.getTag().equals(tag)) continue;
                return relationshipStyle;
            }
        }
        return null;
    }

    public ElementStyle findElementStyle(Element element) {
        ElementStyle style = new ElementStyle("").background("#dddddd").color("#000000").shape(Shape.Box);
        if (element != null) {
            for (String tag : element.getTagsAsSet()) {
                ElementStyle elementStyle = this.findElementStyle(tag);
                if (elementStyle == null) continue;
                if (elementStyle.getBackground() != null && elementStyle.getBackground().trim().length() > 0) {
                    style.setBackground(elementStyle.getBackground());
                }
                if (elementStyle.getColor() != null && elementStyle.getColor().trim().length() > 0) {
                    style.setColor(elementStyle.getColor());
                }
                if (elementStyle.getShape() == null) continue;
                style.setShape(elementStyle.getShape());
            }
        }
        return style;
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship) {
        RelationshipStyle style = new RelationshipStyle("").color("#707070");
        if (relationship != null) {
            for (String tag : relationship.getTagsAsSet()) {
                RelationshipStyle relationshipStyle = this.findRelationshipStyle(tag);
                if (relationshipStyle == null || relationshipStyle.getColor() == null || relationshipStyle.getColor().trim().length() <= 0) continue;
                style.setColor(relationshipStyle.getColor());
            }
        }
        return style;
    }
}

