/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.PropertyHolder;
import com.structurizr.model.Perspective;
import com.structurizr.util.StringUtils;
import com.structurizr.util.TagUtils;
import com.structurizr.util.Url;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class ModelItem
implements PropertyHolder {
    private String id = "";
    private Set<String> tags = new LinkedHashSet<String>();
    private String url;
    private Map<String, String> properties = new HashMap<String, String>();
    private Set<Perspective> perspectives = new HashSet<Perspective>();

    @JsonIgnore
    public abstract String getCanonicalName();

    @JsonIgnore
    public abstract Set<String> getDefaultTags();

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getTags() {
        return TagUtils.toString(this.getTagsAsSet());
    }

    @JsonIgnore
    public Set<String> getTagsAsSet() {
        LinkedHashSet<String> setOfTags = new LinkedHashSet<String>(this.getDefaultTags());
        setOfTags.addAll(this.tags);
        return setOfTags;
    }

    void setTags(String tags) {
        this.tags.clear();
        if (tags == null) {
            return;
        }
        Collections.addAll(this.tags, tags.split(","));
    }

    public void addTags(String ... tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            if (tag == null) continue;
            this.tags.add(tag.trim());
        }
    }

    public boolean removeTag(String tag) {
        if (tag != null) {
            return this.tags.remove(tag.trim());
        }
        return false;
    }

    public boolean hasTag(String tag) {
        return this.getTagsAsSet().contains(tag.trim());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (StringUtils.isNullOrEmpty(url)) {
            this.url = null;
        } else if (url.startsWith("{workspace}")) {
            this.url = url;
        } else if (Url.isUrl(url)) {
            this.url = url;
        } else {
            throw new IllegalArgumentException(url + " is not a valid URL.");
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }

    public Set<Perspective> getPerspectives() {
        return new HashSet<Perspective>(this.perspectives);
    }

    void setPerspectives(Set<Perspective> perspectives) {
        this.perspectives.clear();
        if (perspectives == null) {
            return;
        }
        this.perspectives.addAll(perspectives);
    }

    public Perspective addPerspective(String name, String description) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (StringUtils.isNullOrEmpty(description)) {
            throw new IllegalArgumentException("A description must be specified.");
        }
        if (this.perspectives.stream().filter(p -> p.getName().equals(name)).count() > 0L) {
            throw new IllegalArgumentException("A perspective named \"" + name + "\" already exists.");
        }
        Perspective perspective = new Perspective(name, description);
        this.perspectives.add(perspective);
        return perspective;
    }
}

