/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.PropertyHolder;
import com.structurizr.view.ViewSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class View
implements PropertyHolder {
    private String key;
    private int order;
    private String title;
    private String description;
    private Map<String, String> properties = new HashMap<String, String>();
    private ViewSet viewSet;

    View() {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String key) {
        if (key != null) {
            key = key.replaceAll("/", "_");
        }
        this.key = key;
    }

    public int getOrder() {
        return this.order;
    }

    void setOrder(int order) {
        this.order = Math.max(1, order);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public abstract String getName();

    void setViewSet(@Nonnull ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    @JsonIgnore
    public ViewSet getViewSet() {
        return this.viewSet;
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }
}

