/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Relationship;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DeploymentNode
extends DeploymentElement {
    private DeploymentNode parent;
    private String technology;
    private int instances = 1;
    private Set<DeploymentNode> children = new HashSet<DeploymentNode>();
    private Set<ContainerInstance> containerInstances = new HashSet<ContainerInstance>();

    public ContainerInstance add(Container container) {
        return this.add(container, true);
    }

    public ContainerInstance add(Container container, boolean replicateContainerRelationships) {
        ContainerInstance containerInstance = this.getModel().addContainerInstance(this, container, replicateContainerRelationships);
        this.containerInstances.add(containerInstance);
        return containerInstance;
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology) {
        return this.addDeploymentNode(name, description, technology, 1);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances) {
        return this.addDeploymentNode(name, description, technology, instances, null);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances, Map<String, String> properties) {
        DeploymentNode deploymentNode = this.getModel().addDeploymentNode(this, this.getEnvironment(), name, description, technology, instances, properties);
        if (deploymentNode != null) {
            this.children.add(deploymentNode);
        }
        return deploymentNode;
    }

    public DeploymentNode getDeploymentNodeWithName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        for (DeploymentNode deploymentNode : this.getChildren()) {
            if (!deploymentNode.getName().equals(name)) continue;
            return deploymentNode;
        }
        return null;
    }

    public Relationship uses(DeploymentNode destination, String description, String technology) {
        return this.uses(destination, description, technology, InteractionStyle.Synchronous);
    }

    public Relationship uses(DeploymentNode destination, String description, String technology, InteractionStyle interactionStyle) {
        return this.getModel().addRelationship(this, destination, description, technology, interactionStyle);
    }

    public Set<DeploymentNode> getChildren() {
        return new HashSet<DeploymentNode>(this.children);
    }

    void setChildren(Set<DeploymentNode> children) {
        if (children != null) {
            this.children = new HashSet<DeploymentNode>(children);
        }
    }

    @JsonIgnore
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Set<ContainerInstance> getContainerInstances() {
        return new HashSet<ContainerInstance>(this.containerInstances);
    }

    void setContainerInstances(Set<ContainerInstance> containerInstances) {
        if (containerInstances != null) {
            this.containerInstances = new HashSet<ContainerInstance>(containerInstances);
        }
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.parent;
    }

    void setParent(DeploymentNode parent) {
        this.parent = parent;
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        this.instances = instances;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Deployment Node"));
    }

    @Override
    public String getCanonicalName() {
        if (this.getParent() != null) {
            return this.getParent().getCanonicalName() + "/" + this.formatForCanonicalName(this.getName());
        }
        return "/Deployment/" + this.formatForCanonicalName(this.getEnvironment()) + "/" + this.formatForCanonicalName(this.getName());
    }
}

