/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.structurizr.model.Element;
import com.structurizr.model.IdGenerator;
import com.structurizr.model.Relationship;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestIdGenerator
implements IdGenerator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private final MessageDigest digest;
    private final int length;

    public static MessageDigestIdGenerator getInstance(String algorithm) {
        return MessageDigestIdGenerator.getInstance(algorithm, Integer.MAX_VALUE);
    }

    public static MessageDigestIdGenerator getInstance(String algorithm, int length) {
        try {
            return new MessageDigestIdGenerator(MessageDigest.getInstance(algorithm), length);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unknown algorithm: " + algorithm, e);
        }
    }

    public MessageDigestIdGenerator(MessageDigest digest, int length) {
        this.digest = digest;
        this.length = length;
    }

    @Override
    public void found(String id) {
    }

    @Override
    public String generateId(Element element) {
        return this.generateId(element.getCanonicalName());
    }

    @Override
    public String generateId(Relationship relationship) {
        return this.generateId(relationship.getSource().getCanonicalName(), relationship.getDescription(), relationship.getDestination().getCanonicalName());
    }

    public synchronized String generateId(String ... terms) {
        this.digest.reset();
        for (String term : terms) {
            if (term == null) continue;
            this.digest.update(term.getBytes(UTF8));
        }
        byte[] bytes = this.digest.digest();
        char[] chars = new char[Math.min(bytes.length * 2, this.length)];
        int b = 0;
        int c = 0;
        while (b < bytes.length && c < chars.length) {
            int value = bytes[b++] & 0xFF;
            chars[c++] = HEX_CHARS[value >>> 4];
            if (c >= chars.length) continue;
            chars[c++] = HEX_CHARS[value & 0xF];
        }
        return new String(chars);
    }
}

