/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.util.Url;
import com.structurizr.view.Branding;
import com.structurizr.view.Styles;
import com.structurizr.view.Terminology;
import com.structurizr.view.View;
import com.structurizr.view.ViewSortOrder;

public final class Configuration {
    private Branding branding = new Branding();
    private Styles styles = new Styles();
    private String theme;
    private Terminology terminology = new Terminology();
    private String defaultView;
    private String lastSavedView;
    private ViewSortOrder viewSortOrder;

    public Styles getStyles() {
        return this.styles;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String url) {
        if (url != null && url.trim().length() > 0) {
            if (Url.isUrl(url)) {
                this.theme = url.trim();
            } else {
                throw new IllegalArgumentException(url + " is not a valid URL.");
            }
        }
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    @JsonSetter
    void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public void setDefaultView(View view) {
        if (view != null) {
            this.defaultView = view.getKey();
        }
    }

    @JsonGetter
    String getLastSavedView() {
        return this.lastSavedView;
    }

    @JsonSetter
    void setLastSavedView(String lastSavedView) {
        this.lastSavedView = lastSavedView;
    }

    public void copyConfigurationFrom(Configuration configuration) {
        this.setLastSavedView(configuration.getLastSavedView());
    }

    public Branding getBranding() {
        return this.branding;
    }

    void setBranding(Branding branding) {
        this.branding = branding;
    }

    public Terminology getTerminology() {
        return this.terminology;
    }

    void setTerminology(Terminology terminology) {
        this.terminology = terminology;
    }

    public ViewSortOrder getViewSortOrder() {
        return this.viewSortOrder;
    }

    public void setViewSortOrder(ViewSortOrder viewSortOrder) {
        this.viewSortOrder = viewSortOrder;
    }
}

