/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Animation;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public final class DeploymentView
extends View {
    private Model model;
    private String environment;
    private List<Animation> animations = new ArrayList<Animation>();

    DeploymentView() {
    }

    DeploymentView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
    }

    DeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.model = softwareSystem.getModel();
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public void addAllDeploymentNodes() {
        this.getModel().getDeploymentNodes().forEach(this::add);
    }

    public void add(@Nonnull DeploymentNode deploymentNode) {
        this.add(deploymentNode, true);
    }

    public void add(@Nonnull DeploymentNode deploymentNode, boolean addRelationships) {
        if (deploymentNode == null) {
            throw new IllegalArgumentException("A deployment node must be specified.");
        }
        if (this.addContainerInstancesAndDeploymentNodes(deploymentNode, addRelationships)) {
            for (Element parent = deploymentNode.getParent(); parent != null; parent = parent.getParent()) {
                this.addElement(parent, addRelationships);
            }
        }
    }

    private boolean addContainerInstancesAndDeploymentNodes(DeploymentNode deploymentNode, boolean addRelationships) {
        boolean hasContainers = false;
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            Container container = containerInstance.getContainer();
            if (this.getSoftwareSystem() != null && !container.getParent().equals(this.getSoftwareSystem())) continue;
            this.addElement(containerInstance, addRelationships);
            hasContainers = true;
        }
        for (DeploymentNode child : deploymentNode.getChildren()) {
            hasContainers |= this.addContainerInstancesAndDeploymentNodes(child, addRelationships);
        }
        if (hasContainers) {
            this.addElement(deploymentNode, addRelationships);
        }
        return hasContainers;
    }

    public RelationshipView add(@Nonnull Relationship relationship) {
        return this.addRelationship(relationship);
    }

    @Override
    public String getName() {
        String name = this.getSoftwareSystem() != null ? this.getSoftwareSystem().getName() + " - Deployment" : "Deployment";
        if (!StringUtils.isNullOrEmpty(this.getEnvironment())) {
            name = name + " - " + this.getEnvironment();
        }
        return name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }

    public void addAnimation(ContainerInstance ... containerInstances) {
        if (containerInstances == null || containerInstances.length == 0) {
            throw new IllegalArgumentException("One or more container instances must be specified.");
        }
        HashSet<String> elementIdsInPreviousAnimationSteps = new HashSet<String>();
        for (Animation animationStep : this.animations) {
            elementIdsInPreviousAnimationSteps.addAll(animationStep.getElements());
        }
        HashSet<Element> elementsInThisAnimationStep = new HashSet<Element>();
        HashSet<Relationship> relationshipsInThisAnimationStep = new HashSet<Relationship>();
        for (ContainerInstance containerInstance : containerInstances) {
            if (!this.isElementInView(containerInstance) || elementIdsInPreviousAnimationSteps.contains(containerInstance.getId())) continue;
            elementIdsInPreviousAnimationSteps.add(containerInstance.getId());
            elementsInThisAnimationStep.add(containerInstance);
            for (Element deploymentNode = this.findDeploymentNode(containerInstance); deploymentNode != null; deploymentNode = ((Element)deploymentNode).getParent()) {
                if (elementIdsInPreviousAnimationSteps.contains(deploymentNode.getId())) continue;
                elementIdsInPreviousAnimationSteps.add(deploymentNode.getId());
                elementsInThisAnimationStep.add(deploymentNode);
            }
        }
        if (elementsInThisAnimationStep.size() == 0) {
            throw new IllegalArgumentException("None of the specified container instances exist in this view.");
        }
        for (RelationshipView relationshipView : this.getRelationships()) {
            if ((!elementsInThisAnimationStep.contains(relationshipView.getRelationship().getSource()) || !elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getDestination().getId())) && (!elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getSource().getId()) || !elementsInThisAnimationStep.contains(relationshipView.getRelationship().getDestination()))) continue;
            relationshipsInThisAnimationStep.add(relationshipView.getRelationship());
        }
        this.animations.add(new Animation(this.animations.size() + 1, elementsInThisAnimationStep, relationshipsInThisAnimationStep));
    }

    private DeploymentNode findDeploymentNode(ContainerInstance containerInstance) {
        for (Element element : this.getModel().getElements()) {
            DeploymentNode deploymentNode;
            if (!(element instanceof DeploymentNode) || !(deploymentNode = (DeploymentNode)element).getContainerInstances().contains(containerInstance)) continue;
            return deploymentNode;
        }
        return null;
    }

    public List<Animation> getAnimations() {
        return new ArrayList<Animation>(this.animations);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations != null ? new ArrayList<Animation>(animations) : new ArrayList<Animation>();
    }
}

