/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Shape;
import java.util.Collection;
import java.util.LinkedList;

public final class Styles {
    private static final Integer DEFAULT_WIDTH_OF_ELEMENT = 450;
    private static final Integer DEFAULT_HEIGHT_OF_ELEMENT = 300;
    private static final Integer DEFAULT_WIDTH_OF_PERSON = 400;
    private static final Integer DEFAULT_HEIGHT_OF_PERSON = 400;
    private Collection<ElementStyle> elements = new LinkedList<ElementStyle>();
    private Collection<RelationshipStyle> relationships = new LinkedList<RelationshipStyle>();

    public Collection<ElementStyle> getElements() {
        return this.elements;
    }

    public void add(ElementStyle elementStyle) {
        if (elementStyle != null) {
            this.elements.add(elementStyle);
        }
    }

    public ElementStyle addElementStyle(String tag) {
        ElementStyle elementStyle = null;
        if (tag != null) {
            if (this.elements.stream().anyMatch(es -> es.getTag().equals(tag))) {
                throw new IllegalArgumentException("An element style for the tag \"" + tag + "\" already exists.");
            }
            elementStyle = new ElementStyle();
            elementStyle.setTag(tag);
            this.add(elementStyle);
        }
        return elementStyle;
    }

    public void clearElementStyles() {
        this.elements = new LinkedList<ElementStyle>();
    }

    public void clearRelationshipStyles() {
        this.relationships = new LinkedList<RelationshipStyle>();
    }

    public Collection<RelationshipStyle> getRelationships() {
        return this.relationships;
    }

    public void add(RelationshipStyle relationshipStyle) {
        if (relationshipStyle != null) {
            this.relationships.add(relationshipStyle);
        }
    }

    public RelationshipStyle addRelationshipStyle(String tag) {
        RelationshipStyle relationshipStyle = null;
        if (tag != null) {
            if (this.relationships.stream().anyMatch(rs -> rs.getTag().equals(tag))) {
                throw new IllegalArgumentException("A relationship style for the tag \"" + tag + "\" already exists.");
            }
            relationshipStyle = new RelationshipStyle();
            relationshipStyle.setTag(tag);
            this.add(relationshipStyle);
        }
        return relationshipStyle;
    }

    private ElementStyle findElementStyle(String tag) {
        if (tag != null) {
            for (ElementStyle elementStyle : this.elements) {
                if (elementStyle == null || !elementStyle.getTag().equals(tag)) continue;
                return elementStyle;
            }
        }
        return null;
    }

    private RelationshipStyle findRelationshipStyle(String tag) {
        if (tag != null) {
            for (RelationshipStyle relationshipStyle : this.relationships) {
                if (relationshipStyle == null || !relationshipStyle.getTag().equals(tag)) continue;
                return relationshipStyle;
            }
        }
        return null;
    }

    public ElementStyle findElementStyle(Element element) {
        ElementStyle style = new ElementStyle("").background("#dddddd").color("#000000").shape(Shape.Box);
        if (element != null) {
            for (String tag : element.getTagsAsSet()) {
                ElementStyle elementStyle = this.findElementStyle(tag);
                if (elementStyle == null) continue;
                if (elementStyle.getWidth() != null) {
                    style.setWidth(elementStyle.getWidth());
                }
                if (elementStyle.getHeight() != null) {
                    style.setHeight(elementStyle.getHeight());
                }
                if (!StringUtils.isNullOrEmpty(elementStyle.getBackground())) {
                    style.setBackground(elementStyle.getBackground());
                }
                if (!StringUtils.isNullOrEmpty(elementStyle.getColor())) {
                    style.setColor(elementStyle.getColor());
                }
                if (!StringUtils.isNullOrEmpty(elementStyle.getStroke())) {
                    style.setStroke(elementStyle.getStroke());
                }
                if (elementStyle.getFontSize() != null) {
                    style.setFontSize(elementStyle.getFontSize());
                }
                if (elementStyle.getShape() != null) {
                    style.setShape(elementStyle.getShape());
                }
                if (elementStyle.getBorder() != null) {
                    style.setBorder(elementStyle.getBorder());
                }
                if (elementStyle.getOpacity() == null) continue;
                style.setOpacity(elementStyle.getOpacity());
            }
        }
        if (style.getWidth() == null) {
            if (style.getShape() == Shape.Person) {
                style.setWidth(DEFAULT_WIDTH_OF_PERSON);
            } else {
                style.setWidth(DEFAULT_WIDTH_OF_ELEMENT);
            }
        }
        if (style.getHeight() == null) {
            if (style.getShape() == Shape.Person) {
                style.setHeight(DEFAULT_HEIGHT_OF_PERSON);
            } else {
                style.setHeight(DEFAULT_HEIGHT_OF_ELEMENT);
            }
        }
        return style;
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship) {
        RelationshipStyle style = new RelationshipStyle("").color("#707070");
        if (relationship != null) {
            for (String tag : relationship.getTagsAsSet()) {
                RelationshipStyle relationshipStyle = this.findRelationshipStyle(tag);
                if (relationshipStyle == null) continue;
                if (relationshipStyle.getThickness() != null) {
                    style.setThickness(relationshipStyle.getThickness());
                }
                if (!StringUtils.isNullOrEmpty(relationshipStyle.getColor())) {
                    style.setColor(relationshipStyle.getColor());
                }
                if (relationshipStyle.getDashed() != null) {
                    style.setDashed(relationshipStyle.getDashed());
                }
                if (relationshipStyle.getRouting() != null) {
                    style.setRouting(relationshipStyle.getRouting());
                }
                if (relationshipStyle.getFontSize() != null) {
                    style.setFontSize(relationshipStyle.getFontSize());
                }
                if (relationshipStyle.getWidth() != null) {
                    style.setWidth(relationshipStyle.getWidth());
                }
                if (relationshipStyle.getPosition() != null) {
                    style.setPosition(relationshipStyle.getPosition());
                }
                if (relationshipStyle.getOpacity() == null) continue;
                style.setOpacity(relationshipStyle.getOpacity());
            }
        }
        return style;
    }
}

