/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.StaticView;
import javax.annotation.Nonnull;

public final class SystemContextView
extends StaticView {
    private boolean enterpriseBoundaryVisible = true;

    SystemContextView() {
    }

    SystemContextView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.addElement(softwareSystem, true);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - System Context";
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (!(element instanceof Person) && !(element instanceof SoftwareSystem)) {
            throw new IllegalArgumentException("A person or software system must be specified.");
        }
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, SoftwareSystem.class);
    }

    public boolean isEnterpriseBoundaryVisible() {
        return this.enterpriseBoundaryVisible;
    }

    public void setEnterpriseBoundaryVisible(boolean enterpriseBoundaryVisible) {
        this.enterpriseBoundaryVisible = enterpriseBoundaryVisible;
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return !this.getSoftwareSystem().equals(element);
    }
}

