/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.WorkspaceValidationException;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.Configuration;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.FilterMode;
import com.structurizr.view.FilteredView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ViewSet {
    private static final Log log = LogFactory.getLog(ViewSet.class);
    private Model model;
    private Collection<SystemLandscapeView> systemLandscapeViews = new HashSet<SystemLandscapeView>();
    private Collection<SystemContextView> systemContextViews = new HashSet<SystemContextView>();
    private Collection<ContainerView> containerViews = new HashSet<ContainerView>();
    private Collection<ComponentView> componentViews = new HashSet<ComponentView>();
    private Collection<DynamicView> dynamicViews = new HashSet<DynamicView>();
    private Collection<DeploymentView> deploymentViews = new HashSet<DeploymentView>();
    private Collection<FilteredView> filteredViews = new HashSet<FilteredView>();
    private Configuration configuration = new Configuration();

    ViewSet() {
    }

    ViewSet(Model model) {
        this.model = model;
    }

    public SystemLandscapeView createSystemLandscapeView(String key, String description) {
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        SystemLandscapeView view = new SystemLandscapeView(this.model, key, description);
        view.setViewSet(this);
        this.systemLandscapeViews.add(view);
        return view;
    }

    public SystemContextView createSystemContextView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        SystemContextView view = new SystemContextView(softwareSystem, key, description);
        view.setViewSet(this);
        this.systemContextViews.add(view);
        return view;
    }

    public ContainerView createContainerView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ContainerView view = new ContainerView(softwareSystem, key, description);
        view.setViewSet(this);
        this.containerViews.add(view);
        return view;
    }

    public ComponentView createComponentView(Container container, String key, String description) {
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        ComponentView view = new ComponentView(container, key, description);
        view.setViewSet(this);
        this.componentViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(String key, String description) {
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(this.model, key, description);
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(softwareSystem, key, description);
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DynamicView createDynamicView(Container container, String key, String description) {
        this.assertThatTheContainerIsNotNull(container);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DynamicView view = new DynamicView(container, key, description);
        view.setViewSet(this);
        this.dynamicViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(String key, String description) {
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DeploymentView view = new DeploymentView(this.model, key, description);
        view.setViewSet(this);
        this.deploymentViews.add(view);
        return view;
    }

    public DeploymentView createDeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        this.assertThatTheSoftwareSystemIsNotNull(softwareSystem);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        DeploymentView view = new DeploymentView(softwareSystem, key, description);
        view.setViewSet(this);
        this.deploymentViews.add(view);
        return view;
    }

    public FilteredView createFilteredView(StaticView view, String key, String description, FilterMode mode, String ... tags) {
        this.assertThatTheViewIsNotNull(view);
        this.assertThatTheViewKeyIsSpecifiedAndUnique(key);
        FilteredView filteredView = new FilteredView(view, key, description, mode, tags);
        this.filteredViews.add(filteredView);
        return filteredView;
    }

    private void assertThatTheViewKeyIsSpecifiedAndUnique(String key) {
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        if (this.getViewWithKey(key) != null || this.getFilteredViewWithKey(key) != null) {
            throw new IllegalArgumentException("A view with the key " + key + " already exists.");
        }
    }

    private void assertThatTheSoftwareSystemIsNotNull(SoftwareSystem softwareSystem) {
        if (softwareSystem == null) {
            throw new IllegalArgumentException("A software system must be specified.");
        }
    }

    private void assertThatTheContainerIsNotNull(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
    }

    private void assertThatTheViewIsNotNull(View view) {
        if (view == null) {
            throw new IllegalArgumentException("A view must be specified.");
        }
    }

    View getViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        HashSet<View> views = new HashSet<View>();
        views.addAll(this.systemLandscapeViews);
        views.addAll(this.systemContextViews);
        views.addAll(this.containerViews);
        views.addAll(this.componentViews);
        views.addAll(this.dynamicViews);
        views.addAll(this.deploymentViews);
        return views.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    FilteredView getFilteredViewWithKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        return this.filteredViews.stream().filter(v -> key.equals(v.getKey())).findFirst().orElse(null);
    }

    public Collection<SystemLandscapeView> getSystemLandscapeViews() {
        return new HashSet<SystemLandscapeView>(this.systemLandscapeViews);
    }

    void setSystemLandscapeViews(Set<SystemLandscapeView> systemLandscapeViews) {
        if (systemLandscapeViews != null) {
            this.systemLandscapeViews = new HashSet<SystemLandscapeView>(systemLandscapeViews);
        }
    }

    @JsonSetter(value="enterpriseContextViews")
    void setEnterpriseContextViews(Collection<SystemLandscapeView> enterpriseContextViews) {
        if (enterpriseContextViews != null) {
            this.systemLandscapeViews = new HashSet<SystemLandscapeView>(enterpriseContextViews);
        }
    }

    public Collection<SystemContextView> getSystemContextViews() {
        return new HashSet<SystemContextView>(this.systemContextViews);
    }

    void setSystemContextViews(Set<SystemContextView> systemContextViews) {
        if (systemContextViews != null) {
            this.systemContextViews = new HashSet<SystemContextView>(systemContextViews);
        }
    }

    public Collection<ContainerView> getContainerViews() {
        return new HashSet<ContainerView>(this.containerViews);
    }

    void setContainerViews(Set<ContainerView> containerViews) {
        if (containerViews != null) {
            this.containerViews = new HashSet<ContainerView>(containerViews);
        }
    }

    public Collection<ComponentView> getComponentViews() {
        return new HashSet<ComponentView>(this.componentViews);
    }

    void setComponentViews(Set<ComponentView> componentViews) {
        if (componentViews != null) {
            this.componentViews = new HashSet<ComponentView>(componentViews);
        }
    }

    public Collection<DynamicView> getDynamicViews() {
        return new HashSet<DynamicView>(this.dynamicViews);
    }

    void setDynamicViews(Set<DynamicView> dynamicViews) {
        if (dynamicViews != null) {
            this.dynamicViews = new HashSet<DynamicView>(dynamicViews);
        }
    }

    public Collection<FilteredView> getFilteredViews() {
        return new HashSet<FilteredView>(this.filteredViews);
    }

    void setFilteredViews(Set<FilteredView> filteredViews) {
        if (filteredViews != null) {
            this.filteredViews = new HashSet<FilteredView>(filteredViews);
        }
    }

    public Collection<DeploymentView> getDeploymentViews() {
        return new HashSet<DeploymentView>(this.deploymentViews);
    }

    void setDeploymentViews(Set<DeploymentView> deploymentViews) {
        if (deploymentViews != null) {
            this.deploymentViews = new HashSet<DeploymentView>(deploymentViews);
        }
    }

    @JsonIgnore
    public Collection<View> getViews() {
        HashSet<View> views = new HashSet<View>();
        views.addAll(this.getSystemLandscapeViews());
        views.addAll(this.getSystemContextViews());
        views.addAll(this.getContainerViews());
        views.addAll(this.getComponentViews());
        views.addAll(this.getDynamicViews());
        views.addAll(this.getDeploymentViews());
        return views;
    }

    void hydrate(Model model) {
        SoftwareSystem softwareSystem;
        this.model = model;
        this.checkViewKeysAreUnique();
        for (SystemLandscapeView systemLandscapeView : this.systemLandscapeViews) {
            systemLandscapeView.setModel(model);
            this.hydrateView(systemLandscapeView);
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            softwareSystem = model.getSoftwareSystemWithId(systemContextView.getSoftwareSystemId());
            if (softwareSystem == null) {
                throw new WorkspaceValidationException(String.format("The system context view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", systemContextView.getKey(), systemContextView.getSoftwareSystemId()));
            }
            systemContextView.setSoftwareSystem(softwareSystem);
            this.hydrateView(systemContextView);
        }
        for (ContainerView containerView : this.containerViews) {
            softwareSystem = model.getSoftwareSystemWithId(containerView.getSoftwareSystemId());
            if (softwareSystem == null) {
                throw new WorkspaceValidationException(String.format("The container view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", containerView.getKey(), containerView.getSoftwareSystemId()));
            }
            containerView.setSoftwareSystem(softwareSystem);
            this.hydrateView(containerView);
        }
        for (ComponentView componentView : this.componentViews) {
            Container container = (Container)model.getElement(componentView.getContainerId());
            if (container == null) {
                throw new WorkspaceValidationException(String.format("The component view with key \"%s\" is associated with a container (id=%s), but that element does not exist in the model.", componentView.getKey(), componentView.getContainerId()));
            }
            componentView.setContainer(container);
            componentView.setSoftwareSystem(container.getSoftwareSystem());
            this.hydrateView(componentView);
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            if (!StringUtils.isNullOrEmpty(dynamicView.getElementId())) {
                Element element = model.getElement(dynamicView.getElementId());
                if (element == null) {
                    throw new WorkspaceValidationException(String.format("The dynamic view with key \"%s\" is associated with an element (id=%s), but that element does not exist in the model.", dynamicView.getKey(), dynamicView.getElementId()));
                }
                dynamicView.setElement(element);
            }
            dynamicView.setModel(model);
            this.hydrateView(dynamicView);
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            if (!StringUtils.isNullOrEmpty(deploymentView.getSoftwareSystemId())) {
                softwareSystem = model.getSoftwareSystemWithId(deploymentView.getSoftwareSystemId());
                if (softwareSystem == null) {
                    throw new WorkspaceValidationException(String.format("The deployment view with key \"%s\" is associated with a software system (id=%s), but that element does not exist in the model.", deploymentView.getKey(), deploymentView.getSoftwareSystemId()));
                }
                deploymentView.setSoftwareSystem(softwareSystem);
            }
            deploymentView.setModel(model);
            this.hydrateView(deploymentView);
        }
        for (FilteredView filteredView : this.filteredViews) {
            View view = this.getViewWithKey(filteredView.getBaseViewKey());
            if (view == null) {
                throw new WorkspaceValidationException(String.format("The filtered view with key \"%s\" is based upon a view (key=%s), but that view does not exist in the workspace.", filteredView.getKey(), filteredView.getBaseViewKey()));
            }
            filteredView.setView(view);
        }
    }

    private void hydrateView(View view) {
        view.setViewSet(this);
        for (ElementView elementView : view.getElements()) {
            Element element = this.model.getElement(elementView.getId());
            if (element == null) {
                throw new WorkspaceValidationException(String.format("The view with key \"%s\" references an element (id=%s), but that element does not exist in the model.", view.getKey(), elementView.getId()));
            }
            elementView.setElement(element);
        }
        for (RelationshipView relationshipView : view.getRelationships()) {
            Relationship relationship = this.model.getRelationship(relationshipView.getId());
            if (relationship == null) {
                throw new WorkspaceValidationException(String.format("The view with key \"%s\" references a relationship (id=%s), but that relationship does not exist in the model.", view.getKey(), relationshipView.getId()));
            }
            relationshipView.setRelationship(relationship);
        }
    }

    private void checkViewKeysAreUnique() {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<View> views = new ArrayList<View>();
        views.addAll(this.systemLandscapeViews);
        views.addAll(this.systemContextViews);
        views.addAll(this.containerViews);
        views.addAll(this.componentViews);
        views.addAll(this.dynamicViews);
        views.addAll(this.deploymentViews);
        for (View view : views) {
            if (keys.contains(view.getKey())) {
                throw new WorkspaceValidationException("A view with the key " + view.getKey() + " already exists.");
            }
            keys.add(view.getKey());
        }
        for (FilteredView filteredView : this.filteredViews) {
            if (keys.contains(filteredView.getKey())) {
                throw new WorkspaceValidationException("A view with the key " + filteredView.getKey() + " already exists.");
            }
            keys.add(filteredView.getKey());
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void copyLayoutInformationFrom(ViewSet source) {
        View sourceView;
        for (SystemLandscapeView systemLandscapeView : this.systemLandscapeViews) {
            sourceView = this.findView(source.getSystemLandscapeViews(), systemLandscapeView);
            if (sourceView != null) {
                systemLandscapeView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + systemLandscapeView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (SystemContextView systemContextView : this.systemContextViews) {
            sourceView = this.findView(source.getSystemContextViews(), systemContextView);
            if (sourceView != null) {
                systemContextView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + systemContextView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ContainerView containerView : this.containerViews) {
            sourceView = this.findView(source.getContainerViews(), containerView);
            if (sourceView != null) {
                containerView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + containerView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (ComponentView componentView : this.componentViews) {
            sourceView = this.findView(source.getComponentViews(), componentView);
            if (sourceView != null) {
                componentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + componentView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DynamicView dynamicView : this.dynamicViews) {
            sourceView = this.findView(source.getDynamicViews(), dynamicView);
            if (sourceView != null) {
                dynamicView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + dynamicView.getName() + "\" ... diagram layout information may be lost."));
        }
        for (DeploymentView deploymentView : this.deploymentViews) {
            sourceView = this.findView(source.getDeploymentViews(), deploymentView);
            if (sourceView != null) {
                deploymentView.copyLayoutInformationFrom(sourceView);
                continue;
            }
            log.warn((Object)("Could not find a matching view for \"" + deploymentView.getName() + "\" ... diagram layout information may be lost."));
        }
    }

    private <T extends View> T findView(Collection<T> views, T sourceView) {
        for (View view : views) {
            if (view.getKey() == null || !view.getKey().equals(sourceView.getKey())) continue;
            return (T)view;
        }
        for (View view : views) {
            if (!view.getName().equals(sourceView.getName())) continue;
            if (view.getDescription() != null) {
                if (!view.getDescription().equals(sourceView.getDescription())) continue;
                return (T)view;
            }
            return (T)view;
        }
        return null;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.systemLandscapeViews.isEmpty() && this.systemContextViews.isEmpty() && this.containerViews.isEmpty() && this.componentViews.isEmpty() && this.dynamicViews.isEmpty() && this.deploymentViews.isEmpty() && this.filteredViews.isEmpty();
    }
}

