/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.structurizr.Workspace;
import com.structurizr.documentation.Documentation;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.FormatFinder;
import com.structurizr.documentation.FormattedContent;
import com.structurizr.documentation.Image;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.TemplateMetadata;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;

public abstract class DocumentationTemplate {
    private Documentation documentation;

    public DocumentationTemplate(@Nonnull Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be specified.");
        }
        this.documentation = workspace.getDocumentation();
        this.documentation.setTemplate(this.getMetadata());
    }

    public Section addSection(String title, File ... files) throws IOException {
        return this.add(null, title, files);
    }

    @Nonnull
    public Section addSection(String title, Format format, String content) {
        return this.add(null, title, format, content);
    }

    @Nonnull
    public Section addSection(SoftwareSystem softwareSystem, String title, File ... files) throws IOException {
        return this.add((Element)softwareSystem, title, files);
    }

    public Section addSection(SoftwareSystem softwareSystem, String title, Format format, String content) {
        return this.add((Element)softwareSystem, title, format, content);
    }

    public Section addSection(Container container, String title, File ... files) throws IOException {
        return this.add((Element)container, title, files);
    }

    public Section addSection(Container container, String title, Format format, String content) {
        return this.add((Element)container, title, format, content);
    }

    public Section addSection(Component component, String title, File ... files) throws IOException {
        return this.add((Element)component, title, files);
    }

    public Section addSection(Component component, String title, Format format, String content) {
        return this.add((Element)component, title, format, content);
    }

    private Section add(Element element, @Nonnull String title, @Nonnull Format format, @Nonnull String content) {
        return this.documentation.addSection(element, title, format, content);
    }

    @Nonnull
    private Section add(Element element, @Nonnull String title, File ... files) throws IOException {
        FormattedContent content = this.readFiles(files);
        return this.documentation.addSection(element, title, content.getFormat(), content.getContent());
    }

    private FormattedContent readFiles(File ... files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("One or more files must be specified.");
        }
        Format format = Format.Markdown;
        StringBuilder content = new StringBuilder();
        for (File file : files) {
            Object[] filesInDirectory;
            if (file == null) {
                throw new IllegalArgumentException("One or more files must be specified.");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException(file.getCanonicalPath() + " does not exist.");
            }
            if (content.length() > 0) {
                content.append(System.lineSeparator());
            }
            if (file.isFile()) {
                format = FormatFinder.findFormat(file);
                content.append(new String(Files.readAllBytes(file.toPath()), "UTF-8"));
                continue;
            }
            if (!file.isDirectory() || (filesInDirectory = file.listFiles()) == null) continue;
            Arrays.sort(filesInDirectory);
            content.append(this.readFiles((File[])filesInDirectory).getContent());
        }
        return new FormattedContent(content.toString(), format);
    }

    public Collection<Image> addImages(File path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Directory path must not be null.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException("The directory " + path.getCanonicalPath() + " does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getCanonicalPath() + " is not a directory.");
        }
        return this.addImagesFromPath("", path);
    }

    private Collection<Image> addImagesFromPath(String root, File path) throws IOException {
        HashSet<Image> images = new HashSet<Image>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (file.isDirectory()) {
                    images.addAll(this.addImagesFromPath(file.getName() + "/", file));
                    continue;
                }
                if (!name.endsWith(".png") && !name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".gif")) continue;
                Image image = this.addImage(file);
                if (!root.isEmpty()) {
                    image.setName(root + image.getName());
                }
                images.add(image);
            }
        }
        return images;
    }

    public Image addImage(File file) throws IOException {
        String contentType = ImageUtils.getContentType(file);
        String base64Content = ImageUtils.getImageAsBase64(file);
        Image image = new Image(file.getName(), contentType, base64Content);
        this.documentation.addImage(image);
        return image;
    }

    protected abstract TemplateMetadata getMetadata();
}

