/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DeploymentNode
extends DeploymentElement {
    private String technology;
    private int instances = 1;
    private Set<DeploymentNode> children = new HashSet<DeploymentNode>();
    private Set<InfrastructureNode> infrastructureNodes = new HashSet<InfrastructureNode>();
    private Set<SoftwareSystemInstance> softwareSystemInstances = new HashSet<SoftwareSystemInstance>();
    private Set<ContainerInstance> containerInstances = new HashSet<ContainerInstance>();

    public SoftwareSystemInstance add(SoftwareSystem softwareSystem) {
        return this.add(softwareSystem, "Default");
    }

    public SoftwareSystemInstance add(SoftwareSystem softwareSystem, String deploymentGroup) {
        SoftwareSystemInstance softwareSystemInstance = this.getModel().addSoftwareSystemInstance(this, softwareSystem, deploymentGroup);
        this.softwareSystemInstances.add(softwareSystemInstance);
        return softwareSystemInstance;
    }

    public ContainerInstance add(Container container) {
        return this.add(container, "Default");
    }

    public ContainerInstance add(Container container, String deploymentGroup) {
        ContainerInstance containerInstance = this.getModel().addContainerInstance(this, container, deploymentGroup);
        this.containerInstances.add(containerInstance);
        return containerInstance;
    }

    public DeploymentNode addDeploymentNode(String name) {
        return this.addDeploymentNode(name, null, null);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology) {
        return this.addDeploymentNode(name, description, technology, 1);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances) {
        return this.addDeploymentNode(name, description, technology, instances, null);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances, Map<String, String> properties) {
        DeploymentNode deploymentNode = this.getModel().addDeploymentNode(this, this.getEnvironment(), name, description, technology, instances, properties);
        if (deploymentNode != null) {
            this.children.add(deploymentNode);
        }
        return deploymentNode;
    }

    public DeploymentNode getDeploymentNodeWithName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        for (DeploymentNode deploymentNode : this.getChildren()) {
            if (!deploymentNode.getName().equals(name)) continue;
            return deploymentNode;
        }
        return null;
    }

    public InfrastructureNode getInfrastructureNodeWithName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        for (InfrastructureNode infrastructureNode : this.getInfrastructureNodes()) {
            if (!infrastructureNode.getName().equals(name)) continue;
            return infrastructureNode;
        }
        return null;
    }

    public InfrastructureNode addInfrastructureNode(String name) {
        return this.addInfrastructureNode(name, null, null);
    }

    public InfrastructureNode addInfrastructureNode(String name, String description, String technology) {
        return this.addInfrastructureNode(name, description, technology, null);
    }

    public InfrastructureNode addInfrastructureNode(String name, String description, String technology, Map<String, String> properties) {
        InfrastructureNode infrastructureNode = this.getModel().addInfrastructureNode(this, name, description, technology, properties);
        if (infrastructureNode != null) {
            this.infrastructureNodes.add(infrastructureNode);
        }
        return infrastructureNode;
    }

    public Relationship uses(DeploymentNode destination, String description, String technology) {
        return this.uses(destination, description, technology, null);
    }

    public Relationship uses(DeploymentNode destination, String description, String technology, InteractionStyle interactionStyle) {
        return this.uses(destination, description, technology, interactionStyle, new String[0]);
    }

    public Relationship uses(DeploymentNode destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        return this.getModel().addRelationship(this, destination, description, technology, interactionStyle, tags);
    }

    public Set<DeploymentNode> getChildren() {
        return new HashSet<DeploymentNode>(this.children);
    }

    void setChildren(Set<DeploymentNode> children) {
        if (children != null) {
            this.children = new HashSet<DeploymentNode>(children);
        }
    }

    public Set<InfrastructureNode> getInfrastructureNodes() {
        return new HashSet<InfrastructureNode>(this.infrastructureNodes);
    }

    void setInfrastructureNodes(Set<InfrastructureNode> infrastructureNodes) {
        if (infrastructureNodes != null) {
            this.infrastructureNodes = new HashSet<InfrastructureNode>(infrastructureNodes);
        }
    }

    @JsonIgnore
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Set<SoftwareSystemInstance> getSoftwareSystemInstances() {
        return new HashSet<SoftwareSystemInstance>(this.softwareSystemInstances);
    }

    void setSoftwareSystemInstances(Set<SoftwareSystemInstance> softwareSystemInstances) {
        if (softwareSystemInstances != null) {
            this.softwareSystemInstances = new HashSet<SoftwareSystemInstance>(softwareSystemInstances);
        }
    }

    public Set<ContainerInstance> getContainerInstances() {
        return new HashSet<ContainerInstance>(this.containerInstances);
    }

    void setContainerInstances(Set<ContainerInstance> containerInstances) {
        if (containerInstances != null) {
            this.containerInstances = new HashSet<ContainerInstance>(containerInstances);
        }
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    public int getInstances() {
        return this.instances;
    }

    public void setInstances(int instances) {
        if (instances < 1) {
            throw new IllegalArgumentException("Number of instances must be a positive integer.");
        }
        this.instances = instances;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Deployment Node"));
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }
}

