/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Relationship;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class InfrastructureNode
extends DeploymentElement {
    private DeploymentNode parent;
    private String technology;

    public Relationship uses(DeploymentElement destination, String description, String technology) {
        return this.uses(destination, description, technology, InteractionStyle.Synchronous);
    }

    public Relationship uses(DeploymentElement destination, String description, String technology, InteractionStyle interactionStyle) {
        return this.uses(destination, description, technology, interactionStyle, new String[0]);
    }

    public Relationship uses(DeploymentElement destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        return this.getModel().addRelationship(this, destination, description, technology, interactionStyle, tags);
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    @Override
    @JsonIgnore
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Infrastructure Node"));
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }
}

