/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.view.Animation;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public final class CustomView
extends View {
    private List<Animation> animations = new ArrayList<Animation>();
    private Model model;

    CustomView() {
    }

    CustomView(Model model, String key, String title, String description) {
        super(null, key, description);
        this.setTitle(title);
        this.model = model;
    }

    @Override
    public String getName() {
        return "Custom - " + this.getTitle();
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    protected void checkElementCanBeAdded(Element element) {
        if (!(element instanceof CustomElement)) {
            throw new ElementNotPermittedInViewException("Only custom elements can be added to a custom view.");
        }
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }

    public RelationshipView add(@Nonnull Relationship relationship) {
        return this.addRelationship(relationship);
    }

    public void addAnimation(CustomElement ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("One or more elements must be specified.");
        }
        HashSet<String> elementIdsInPreviousAnimationSteps = new HashSet<String>();
        for (Animation animationStep : this.animations) {
            elementIdsInPreviousAnimationSteps.addAll(animationStep.getElements());
        }
        HashSet<Element> elementsInThisAnimationStep = new HashSet<Element>();
        HashSet<Relationship> relationshipsInThisAnimationStep = new HashSet<Relationship>();
        for (CustomElement element : elements) {
            if (!this.isElementInView(element) || elementIdsInPreviousAnimationSteps.contains(element.getId())) continue;
            elementIdsInPreviousAnimationSteps.add(element.getId());
            elementsInThisAnimationStep.add(element);
        }
        if (elementsInThisAnimationStep.size() == 0) {
            throw new IllegalArgumentException("None of the specified elements exist in this view.");
        }
        for (RelationshipView relationshipView : this.getRelationships()) {
            if ((!elementsInThisAnimationStep.contains(relationshipView.getRelationship().getSource()) || !elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getDestination().getId())) && (!elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getSource().getId()) || !elementsInThisAnimationStep.contains(relationshipView.getRelationship().getDestination()))) continue;
            relationshipsInThisAnimationStep.add(relationshipView.getRelationship());
        }
        this.animations.add(new Animation(this.animations.size() + 1, elementsInThisAnimationStep, relationshipsInThisAnimationStep));
    }

    public List<Animation> getAnimations() {
        return new ArrayList<Animation>(this.animations);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations != null ? new ArrayList<Animation>(animations) : new ArrayList<Animation>();
    }
}

