/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Border;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Routing;
import com.structurizr.view.Shape;
import com.structurizr.view.Theme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public final class Styles {
    private static final Integer DEFAULT_WIDTH_OF_ELEMENT = 450;
    private static final Integer DEFAULT_HEIGHT_OF_ELEMENT = 300;
    private static final Integer DEFAULT_WIDTH_OF_PERSON = 400;
    private static final Integer DEFAULT_HEIGHT_OF_PERSON = 400;
    private Collection<ElementStyle> elements = new LinkedList<ElementStyle>();
    private Collection<RelationshipStyle> relationships = new LinkedList<RelationshipStyle>();
    private Map<String, Theme> themes = new LinkedHashMap<String, Theme>();

    public Collection<ElementStyle> getElements() {
        return this.elements;
    }

    public void add(ElementStyle elementStyle) {
        if (elementStyle != null) {
            if (StringUtils.isNullOrEmpty(elementStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.elements.stream().anyMatch(es -> es.getTag().equals(elementStyle.getTag()))) {
                throw new IllegalArgumentException("An element style for the tag \"" + elementStyle.getTag() + "\" already exists.");
            }
            this.elements.add(elementStyle);
        }
    }

    public ElementStyle addElementStyle(String tag) {
        ElementStyle elementStyle = new ElementStyle(tag);
        this.add(elementStyle);
        return elementStyle;
    }

    public void clearElementStyles() {
        this.elements = new LinkedList<ElementStyle>();
    }

    public void clearRelationshipStyles() {
        this.relationships = new LinkedList<RelationshipStyle>();
    }

    public void addDefaultStyles() {
        this.addElementStyle("Element").shape(Shape.RoundedBox);
        this.addElementStyle("Software System").background("#1168bd").color("#ffffff");
        this.addElementStyle("Container").background("#438dd5").color("#ffffff");
        this.addElementStyle("Component").background("#85bbf0").color("#000000");
        this.addElementStyle("Person").background("#08427b").color("#ffffff").shape(Shape.Person);
        this.addElementStyle("Infrastructure Node").background("#ffffff");
    }

    public Collection<RelationshipStyle> getRelationships() {
        return this.relationships;
    }

    public void add(RelationshipStyle relationshipStyle) {
        if (relationshipStyle != null) {
            if (StringUtils.isNullOrEmpty(relationshipStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.relationships.stream().anyMatch(es -> es.getTag().equals(relationshipStyle.getTag()))) {
                throw new IllegalArgumentException("A relationship style for the tag \"" + relationshipStyle.getTag() + "\" already exists.");
            }
            this.relationships.add(relationshipStyle);
        }
    }

    public RelationshipStyle addRelationshipStyle(String tag) {
        RelationshipStyle relationshipStyle = new RelationshipStyle(tag);
        this.add(relationshipStyle);
        return relationshipStyle;
    }

    private ElementStyle findElementStyle(String tag) {
        if (tag == null) {
            return null;
        }
        tag = tag.trim();
        ElementStyle style = new ElementStyle(tag);
        ArrayList<ElementStyle> elementStyles = new ArrayList<ElementStyle>();
        for (Theme theme : this.themes.values()) {
            elementStyles.addAll(theme.getElements());
        }
        elementStyles.addAll(this.elements);
        for (ElementStyle elementStyle : elementStyles) {
            if (elementStyle == null || !elementStyle.getTag().equals(tag)) continue;
            style.copyFrom(elementStyle);
        }
        return style;
    }

    private RelationshipStyle findRelationshipStyle(String tag) {
        if (tag == null) {
            return null;
        }
        tag = tag.trim();
        RelationshipStyle style = new RelationshipStyle(tag);
        ArrayList<RelationshipStyle> relationshipStyles = new ArrayList<RelationshipStyle>();
        for (Theme theme : this.themes.values()) {
            relationshipStyles.addAll(theme.getRelationships());
        }
        relationshipStyles.addAll(this.relationships);
        for (RelationshipStyle relationshipStyle : relationshipStyles) {
            if (relationshipStyle == null || !relationshipStyle.getTag().equals(tag)) continue;
            style.copyFrom(relationshipStyle);
        }
        return style;
    }

    public ElementStyle findElementStyle(Element element) {
        ElementStyle style = new ElementStyle("").background("#dddddd").color("#000000").shape(Shape.Box).fontSize(24).border(Border.Solid).opacity(100).metadata(true).description(true);
        if (element instanceof DeploymentNode) {
            style.setBackground("#ffffff");
            style.setColor("#000000");
            style.setStroke("#888888");
        }
        if (element != null) {
            for (String tag : element.getTagsAsSet()) {
                ElementStyle elementStyle = this.findElementStyle(tag);
                if (elementStyle == null) continue;
                style.copyFrom(elementStyle);
            }
        }
        if (style.getWidth() == null) {
            if (style.getShape() == Shape.Person) {
                style.setWidth(DEFAULT_WIDTH_OF_PERSON);
            } else {
                style.setWidth(DEFAULT_WIDTH_OF_ELEMENT);
            }
        }
        if (style.getHeight() == null) {
            if (style.getShape() == Shape.Person || style.getShape() == Shape.Robot) {
                style.setHeight(DEFAULT_HEIGHT_OF_PERSON);
            } else {
                style.setHeight(DEFAULT_HEIGHT_OF_ELEMENT);
            }
        }
        if (style.getStroke() == null) {
            Color color = Color.decode(style.getBackground());
            style.setStroke(String.format("#%06X", 0xFFFFFF & color.darker().getRGB()));
        }
        return style;
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship) {
        RelationshipStyle style = new RelationshipStyle("").thickness(2).color("#707070").dashed(true).routing(Routing.Direct).fontSize(24).width(200).position(50).opacity(100);
        if (relationship != null) {
            Relationship linkedRelationship;
            String tags = !StringUtils.isNullOrEmpty(relationship.getLinkedRelationshipId()) ? ((linkedRelationship = relationship.getModel().getRelationship(relationship.getLinkedRelationshipId())) != null ? linkedRelationship.getTags() + "," + relationship.getTags() : relationship.getTags()) : relationship.getTags();
            for (String tag : tags.split(",")) {
                RelationshipStyle relationshipStyle = this.findRelationshipStyle(tag);
                if (relationshipStyle == null) continue;
                style.copyFrom(relationshipStyle);
            }
        }
        return style;
    }

    void addStylesFromTheme(String url, Collection<ElementStyle> elements, Collection<RelationshipStyle> relationships) {
        this.themes.put(url, new Theme(elements, relationships));
    }
}

