/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.Workspace;
import com.structurizr.io.plantuml.PlantUMLDiagram;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Location;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PlantUMLWriter {
    private final Map<String, String> skinParams = new LinkedHashMap<String, String>();
    private final List<String> includes = new ArrayList<String>();
    private boolean useSequenceDiagrams = false;
    private boolean includeDiagramMetadata = true;

    PlantUMLWriter() {
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void addIncludeFile(String file) {
        this.addIncludeFile(file, null);
    }

    public void addIncludeFile(String file, int id) {
        this.addIncludeFile(file, String.valueOf(id));
    }

    public void addIncludeFile(String file, String id) {
        if (id == null) {
            this.includes.add(String.format("!include %s", file));
        } else {
            this.includes.add(String.format("!include %s!%s", file, id));
        }
    }

    public void addIncludeURL(URI file) {
        this.addIncludeURL(file, null);
    }

    public void addIncludeURL(URI file, int id) {
        this.addIncludeURL(file, String.valueOf(id));
    }

    public void addIncludeURL(URI file, String id) {
        if (id == null) {
            this.includes.add(String.format("!includeurl %s", file));
        } else {
            this.includes.add(String.format("!includeurl %s!%s", file, id));
        }
    }

    public void clearIncludes() {
        this.includes.clear();
    }

    protected Map<String, String> getSkinParams() {
        return this.skinParams;
    }

    public void addSkinParam(String name, String value) {
        this.skinParams.put(name, value);
    }

    public void clearSkinParams() {
        this.skinParams.clear();
    }

    public boolean isUseSequenceDiagrams() {
        return this.useSequenceDiagrams;
    }

    public void setUseSequenceDiagrams(boolean useSequenceDiagrams) {
        this.useSequenceDiagrams = useSequenceDiagrams;
    }

    public boolean isIncludeDiagramMetadata() {
        return this.includeDiagramMetadata;
    }

    public void setIncludeDiagramMetadata(boolean includeDiagramMetadata) {
        this.includeDiagramMetadata = includeDiagramMetadata;
    }

    public final void write(Workspace workspace, Writer writer) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("A writer must be provided.");
        }
        workspace.getViews().getSystemLandscapeViews().forEach(v -> this.write((SystemLandscapeView)v, writer));
        workspace.getViews().getSystemContextViews().forEach(v -> this.write((SystemContextView)v, writer));
        workspace.getViews().getContainerViews().forEach(v -> this.write((ContainerView)v, writer));
        workspace.getViews().getComponentViews().forEach(v -> this.write((ComponentView)v, writer));
        workspace.getViews().getDynamicViews().forEach(v -> this.write((DynamicView)v, writer));
        workspace.getViews().getDeploymentViews().forEach(v -> this.write((DeploymentView)v, writer));
    }

    public final String toString(View view) {
        StringWriter stringWriter = new StringWriter();
        this.write(view, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public final Collection<PlantUMLDiagram> toPlantUMLDiagrams(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        ArrayList<PlantUMLDiagram> diagrams = new ArrayList<PlantUMLDiagram>();
        for (View view : workspace.getViews().getViews()) {
            StringWriter stringWriter = new StringWriter();
            this.write(view, (Writer)stringWriter);
            diagrams.add(new PlantUMLDiagram(view.getKey(), view.getName(), stringWriter.toString()));
        }
        return diagrams;
    }

    public final void write(View view, Writer writer) {
        if (view == null) {
            throw new IllegalArgumentException("A view must be provided.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("A writer must be provided.");
        }
        if (SystemLandscapeView.class.isAssignableFrom(view.getClass())) {
            this.write((SystemLandscapeView)view, writer);
        } else if (SystemContextView.class.isAssignableFrom(view.getClass())) {
            this.write((SystemContextView)view, writer);
        } else if (ContainerView.class.isAssignableFrom(view.getClass())) {
            this.write((ContainerView)view, writer);
        } else if (ComponentView.class.isAssignableFrom(view.getClass())) {
            this.write((ComponentView)view, writer);
        } else if (DynamicView.class.isAssignableFrom(view.getClass())) {
            this.write((DynamicView)view, writer);
        } else if (DeploymentView.class.isAssignableFrom(view.getClass())) {
            this.write((DeploymentView)view, writer);
        }
    }

    protected void write(SystemLandscapeView view, Writer writer) {
        this.writeSystemLandscapeOrContextView((View)view, writer, view.isEnterpriseBoundaryVisible());
    }

    protected void write(SystemContextView view, Writer writer) {
        this.writeSystemLandscapeOrContextView((View)view, writer, view.isEnterpriseBoundaryVisible());
    }

    void writeSystemLandscapeOrContextView(View view, Writer writer, boolean showEnterpriseBoundary) {
        try {
            this.writeHeader(view, writer);
            boolean enterpriseBoundaryVisible = showEnterpriseBoundary && (view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof Person && ((Person)e).getLocation() == Location.Internal) || view.getElements().stream().map(ElementView::getElement).anyMatch(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.Internal));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() != Location.Internal).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write(view, (Element)e, writer, false));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() != Location.Internal).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write(view, (Element)e, writer, false));
            if (enterpriseBoundaryVisible) {
                String name = view.getModel().getEnterprise() != null ? view.getModel().getEnterprise().getName() : "Enterprise";
                writer.write("package \"" + name + "\" {");
                writer.write(System.lineSeparator());
            }
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() == Location.Internal).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write(view, (Element)e, writer, true));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.Internal).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write(view, (Element)e, writer, true));
            if (enterpriseBoundaryVisible) {
                writer.write("}");
                writer.write(System.lineSeparator());
            }
            this.writeRelationships(view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected abstract void write(ContainerView var1, Writer var2);

    protected abstract void write(ComponentView var1, Writer var2);

    protected abstract void write(DynamicView var1, Writer var2);

    void write(DeploymentView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> ev.getElement() instanceof DeploymentNode && ev.getElement().getParent() == null).map(ev -> (DeploymentNode)ev.getElement()).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write((View)view, (DeploymentNode)e, writer, 0));
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected abstract void write(View var1, DeploymentNode var2, Writer var3, int var4);

    String calculateIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    void write(View view, Element element, Writer writer, boolean indent) {
        this.write(view, element, writer, indent ? 1 : 0);
    }

    protected abstract void write(View var1, Element var2, Writer var3, int var4);

    String backgroundOf(View view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getBackground();
    }

    String strokeOf(View view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getStroke();
    }

    String colorOf(View view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getColor();
    }

    Shape shapeOf(View view, Element element) {
        return view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getShape();
    }

    String plantUMLShapeOf(View view, Element element) {
        Shape shape = view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getShape();
        if (element instanceof DeploymentNode) {
            return "node";
        }
        switch (shape) {
            case Person: {
                return "actor";
            }
            case Component: {
                return "component";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "folder";
            }
            case Ellipse: 
            case Circle: {
                return "storage";
            }
        }
        return "rectangle";
    }

    String plantumlSequenceType(View view, Element element) {
        Shape shape = view.getViewSet().getConfiguration().getStyles().findElementStyle(element).getShape();
        switch (shape) {
            case Box: {
                return "participant";
            }
            case Person: {
                return "actor";
            }
            case Cylinder: {
                return "database";
            }
            case Folder: {
                return "collections";
            }
            case Ellipse: 
            case Circle: {
                return "entity";
            }
        }
        return "participant";
    }

    RelationshipStyle relationshipStyleOf(View view, Relationship relationship) {
        return view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship);
    }

    String idOf(Element e) {
        return e.getId();
    }

    String typeOf(View view, Element e, boolean includeMetadataSymbols) {
        String terminology = view.getViewSet().getConfiguration().getTerminology().findTerminology((ModelItem)e);
        String type = "";
        if (e instanceof Person) {
            type = terminology;
        } else if (e instanceof SoftwareSystem) {
            type = terminology;
        } else if (e instanceof Container) {
            Container container = (Container)e;
            type = terminology + (this.hasValue(container.getTechnology()) ? ": " + container.getTechnology() : "");
        } else if (e instanceof Component) {
            Component component = (Component)e;
            type = terminology + (this.hasValue(component.getTechnology()) ? ": " + component.getTechnology() : "");
        } else if (e instanceof DeploymentNode) {
            DeploymentNode deploymentNode = (DeploymentNode)e;
            type = terminology + (this.hasValue(deploymentNode.getTechnology()) ? ": " + deploymentNode.getTechnology() : "");
        } else if (e instanceof InfrastructureNode) {
            InfrastructureNode infrastructureNode = (InfrastructureNode)e;
            type = terminology + (this.hasValue(infrastructureNode.getTechnology()) ? ": " + infrastructureNode.getTechnology() : "");
        }
        if (includeMetadataSymbols) {
            return "[" + type + "]";
        }
        return type;
    }

    boolean hasValue(String s) {
        return !StringUtils.isNullOrEmpty((String)s);
    }

    protected void writeHeader(View view, Writer writer) throws IOException {
        writer.write(String.format("@startuml(id=%s)", view.getKey().replace(' ', '_')));
        writer.write(System.lineSeparator());
        for (String include : this.includes) {
            writer.write(include);
            writer.write(System.lineSeparator());
        }
        if (this.includeDiagramMetadata) {
            String viewTitle = view.getTitle();
            if (StringUtils.isNullOrEmpty((String)viewTitle)) {
                viewTitle = view.getName();
            }
            writer.write("title " + viewTitle);
            writer.write(System.lineSeparator());
            if (view.getDescription() != null && view.getDescription().trim().length() > 0) {
                writer.write("caption " + view.getDescription());
                writer.write(System.lineSeparator());
            }
        }
        writer.write(System.lineSeparator());
        if (!this.skinParams.isEmpty()) {
            writer.write(String.format("skinparam {%s", System.lineSeparator()));
            for (String name : this.skinParams.keySet()) {
                writer.write(String.format("  %s %s%s", name, this.skinParams.get(name), System.lineSeparator()));
            }
            writer.write(String.format("}%s", System.lineSeparator()));
        }
    }

    protected void writeRelationships(View view, Writer writer) {
        view.getRelationships().stream().sorted(Comparator.comparing(rv -> rv.getRelationship().getSource().getName() + rv.getRelationship().getDestination().getName())).forEach(r -> this.writeRelationship(view, (RelationshipView)r, writer));
    }

    protected abstract void writeRelationship(View var1, RelationshipView var2, Writer var3);

    protected void writeFooter(Writer writer) throws IOException {
        writer.write("@enduml");
    }
}

