/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.TrigonometricQuantity;
import com.synerset.unitility.unitsystem.common.AngleUnit;
import com.synerset.unitility.unitsystem.common.AngleUnits;
import java.util.Objects;

public class Angle
implements TrigonometricQuantity<Angle> {
    private final double value;
    private final double baseValue;
    private final AngleUnit unitType;

    public Angle(double value, AngleUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = AngleUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Angle of(double value, AngleUnit unit) {
        return new Angle(value, unit);
    }

    public static Angle of(double value, String unitSymbol) {
        AngleUnit resolvedUnit = AngleUnits.fromSymbol(unitSymbol);
        return new Angle(value, resolvedUnit);
    }

    public static Angle ofRadians(double value) {
        return new Angle(value, AngleUnits.RADIANS);
    }

    public static Angle ofDegrees(double value) {
        return new Angle(value, AngleUnits.DEGREES);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public AngleUnit getUnitType() {
        return this.unitType;
    }

    public Angle toBaseUnit() {
        double degrees = this.unitType.toValueInBaseUnit(this.value);
        return Angle.of(degrees, AngleUnits.DEGREES);
    }

    public Angle toUnit(AngleUnit targetUnit) {
        double valueInDegrees = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInDegrees);
        return Angle.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Angle withValue(double value) {
        return Angle.of(value, this.unitType);
    }

    public Angle toRadians() {
        return this.toUnit(AngleUnits.RADIANS);
    }

    public Angle toDegrees() {
        return this.toUnit(AngleUnits.DEGREES);
    }

    public double getInRadians() {
        return this.getInUnit(AngleUnits.RADIANS);
    }

    public double getInDegrees() {
        return this.getInUnit(AngleUnits.DEGREES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Angle inputQuantity = (Angle)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        String separator = this.getUnitType().getSymbol().contains("\u00b0") ? "" : " ";
        return "Angle{" + this.value + separator + this.unitType.getSymbol() + "}";
    }
}

