/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.AreaUnit;
import com.synerset.unitility.unitsystem.common.AreaUnits;
import java.util.Objects;

public class Area
implements CalculableQuantity<AreaUnit, Area> {
    public static final Area PHYSICAL_MIN_LIMIT = Area.ofSquareMeters(0.0);
    private final double value;
    private final double baseValue;
    private final AreaUnit unitType;

    public Area(double value, AreaUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = AreaUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Area of(double value, AreaUnit unit) {
        return new Area(value, unit);
    }

    public static Area of(double value, String unitSymbol) {
        AreaUnit resolvedUnit = AreaUnits.fromSymbol(unitSymbol);
        return new Area(value, resolvedUnit);
    }

    public static Area ofSquareMeters(double value) {
        return new Area(value, AreaUnits.SQUARE_METER);
    }

    public static Area ofSquareKilometers(double value) {
        return new Area(value, AreaUnits.SQUARE_KILOMETER);
    }

    public static Area ofSquareCentimeters(double value) {
        return new Area(value, AreaUnits.SQUARE_CENTIMETER);
    }

    public static Area ofSquareMillimeters(double value) {
        return new Area(value, AreaUnits.SQUARE_MILLIMETER);
    }

    public static Area ofAres(double value) {
        return new Area(value, AreaUnits.ARE);
    }

    public static Area ofHectares(double value) {
        return new Area(value, AreaUnits.HECTARE);
    }

    public static Area ofSquareInches(double value) {
        return new Area(value, AreaUnits.SQUARE_INCH);
    }

    public static Area ofSquareFeet(double value) {
        return new Area(value, AreaUnits.SQUARE_FOOT);
    }

    public static Area ofSquareYards(double value) {
        return new Area(value, AreaUnits.SQUARE_YARD);
    }

    public static Area ofAcres(double value) {
        return new Area(value, AreaUnits.ACRE);
    }

    public static Area ofSquareMiles(double value) {
        return new Area(value, AreaUnits.SQUARE_MILE);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public AreaUnit getUnitType() {
        return this.unitType;
    }

    public Area toBaseUnit() {
        double valueInSquareMeters = this.unitType.toValueInBaseUnit(this.value);
        return Area.of(valueInSquareMeters, AreaUnits.SQUARE_METER);
    }

    public Area toUnit(AreaUnit targetUnit) {
        double valueInSquareMeters = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInSquareMeters);
        return Area.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Area withValue(double value) {
        return Area.of(value, this.unitType);
    }

    public Area toSquareMeters() {
        return this.toUnit(AreaUnits.SQUARE_METER);
    }

    public Area toSquareKilometers() {
        return this.toUnit(AreaUnits.SQUARE_KILOMETER);
    }

    public Area toSquareCentimeters() {
        return this.toUnit(AreaUnits.SQUARE_CENTIMETER);
    }

    public Area toSquareMillimeters() {
        return this.toUnit(AreaUnits.SQUARE_MILLIMETER);
    }

    public Area toAres() {
        return this.toUnit(AreaUnits.ARE);
    }

    public Area toHectares() {
        return this.toUnit(AreaUnits.HECTARE);
    }

    public Area toSquareInches() {
        return this.toUnit(AreaUnits.SQUARE_INCH);
    }

    public Area toSquareFeet() {
        return this.toUnit(AreaUnits.SQUARE_FOOT);
    }

    public Area toSquareYards() {
        return this.toUnit(AreaUnits.SQUARE_YARD);
    }

    public Area toAcres() {
        return this.toUnit(AreaUnits.ACRE);
    }

    public Area toSquareMiles() {
        return this.toUnit(AreaUnits.SQUARE_MILE);
    }

    public double getInSquareMeters() {
        return this.getInUnit(AreaUnits.SQUARE_METER);
    }

    public double getInSquareKilometers() {
        return this.getInUnit(AreaUnits.SQUARE_KILOMETER);
    }

    public double getInSquareCentimeters() {
        return this.getInUnit(AreaUnits.SQUARE_CENTIMETER);
    }

    public double getInSquareMillimeters() {
        return this.getInUnit(AreaUnits.SQUARE_MILLIMETER);
    }

    public double getInAres() {
        return this.getInUnit(AreaUnits.ARE);
    }

    public double getInHectares() {
        return this.getInUnit(AreaUnits.HECTARE);
    }

    public double getInSquareInches() {
        return this.getInUnit(AreaUnits.SQUARE_INCH);
    }

    public double getInSquareFeet() {
        return this.getInUnit(AreaUnits.SQUARE_FOOT);
    }

    public double getInSquareYards() {
        return this.getInUnit(AreaUnits.SQUARE_YARD);
    }

    public double getInAcres() {
        return this.getInUnit(AreaUnits.ACRE);
    }

    public double getInSquareMiles() {
        return this.getInUnit(AreaUnits.SQUARE_MILE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Area inputQuantity = (Area)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Area{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

