/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.DistanceUnit;
import com.synerset.unitility.unitsystem.common.DistanceUnits;
import java.util.Objects;

public class Distance
implements CalculableQuantity<DistanceUnit, Distance> {
    public static final Distance PHYSICAL_MIN_LIMIT = Distance.ofMeters(0.0);
    private final double value;
    private final double baseValue;
    private final DistanceUnit unitType;

    public Distance(double value, DistanceUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = DistanceUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Distance of(double value, DistanceUnit unit) {
        return new Distance(value, unit);
    }

    public static Distance of(double value, String unitSymbol) {
        DistanceUnit resolvedUnit = DistanceUnits.fromSymbol(unitSymbol);
        return new Distance(value, resolvedUnit);
    }

    public static Distance ofMeters(double value) {
        return new Distance(value, DistanceUnits.METER);
    }

    public static Distance ofCentimeters(double value) {
        return new Distance(value, DistanceUnits.CENTIMETER);
    }

    public static Distance ofMillimeters(double value) {
        return new Distance(value, DistanceUnits.MILLIMETER);
    }

    public static Distance ofKilometers(double value) {
        return new Distance(value, DistanceUnits.KILOMETER);
    }

    public static Distance ofMiles(double value) {
        return new Distance(value, DistanceUnits.MILE);
    }

    public static Distance ofNauticalMiles(double value) {
        return new Distance(value, DistanceUnits.NAUTICAL_MILE);
    }

    public static Distance ofFeet(double value) {
        return new Distance(value, DistanceUnits.FEET);
    }

    public static Distance ofInches(double value) {
        return new Distance(value, DistanceUnits.INCH);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public DistanceUnit getUnitType() {
        return this.unitType;
    }

    public Distance toBaseUnit() {
        double valueInMeters = this.unitType.toValueInBaseUnit(this.value);
        return Distance.of(valueInMeters, DistanceUnits.METER);
    }

    public Distance toUnit(DistanceUnit targetUnit) {
        double valueInMeters = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInMeters);
        return Distance.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Distance withValue(double value) {
        return Distance.of(value, this.unitType);
    }

    public Distance toMeter() {
        return this.toUnit(DistanceUnits.METER);
    }

    public Distance toCentimeter() {
        return this.toUnit(DistanceUnits.CENTIMETER);
    }

    public Distance toMillimeter() {
        return this.toUnit(DistanceUnits.MILLIMETER);
    }

    public Distance toKilometer() {
        return this.toUnit(DistanceUnits.KILOMETER);
    }

    public Distance toMile() {
        return this.toUnit(DistanceUnits.MILE);
    }

    public Distance toNauticalMile() {
        return this.toUnit(DistanceUnits.NAUTICAL_MILE);
    }

    public Distance toFeet() {
        return this.toUnit(DistanceUnits.FEET);
    }

    public Distance toInch() {
        return this.toUnit(DistanceUnits.INCH);
    }

    public double getInMeters() {
        return this.getInUnit(DistanceUnits.METER);
    }

    public double getInCentimeters() {
        return this.getInUnit(DistanceUnits.CENTIMETER);
    }

    public double getInMillimeters() {
        return this.getInUnit(DistanceUnits.MILLIMETER);
    }

    public double getInKilometers() {
        return this.getInUnit(DistanceUnits.KILOMETER);
    }

    public double getInMiles() {
        return this.getInUnit(DistanceUnits.MILE);
    }

    public double getInNauticalMiles() {
        return this.getInUnit(DistanceUnits.NAUTICAL_MILE);
    }

    public double getInFeet() {
        return this.getInUnit(DistanceUnits.FEET);
    }

    public double getInInches() {
        return this.getInUnit(DistanceUnits.INCH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distance inputQuantity = (Distance)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Distance{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

