/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.VolumeUnit;
import com.synerset.unitility.unitsystem.common.VolumeUnits;
import java.util.Objects;

public class Volume
implements CalculableQuantity<VolumeUnit, Volume> {
    public static final Volume PHYSICAL_MIN_LIMIT = Volume.ofCubicMeters(0.0);
    private final double value;
    private final double baseValue;
    private final VolumeUnit unitType;

    public Volume(double value, VolumeUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = VolumeUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Volume of(double value, VolumeUnit unit) {
        return new Volume(value, unit);
    }

    public static Volume of(double value, String unitSymbol) {
        VolumeUnit resolvedUnit = VolumeUnits.fromSymbol(unitSymbol);
        return new Volume(value, resolvedUnit);
    }

    public static Volume ofCubicMeters(double value) {
        return new Volume(value, VolumeUnits.CUBIC_METER);
    }

    public static Volume ofLiters(double value) {
        return new Volume(value, VolumeUnits.LITER);
    }

    public static Volume ofCubicCentimeters(double value) {
        return new Volume(value, VolumeUnits.CUBIC_CENTIMETER);
    }

    public static Volume ofHectoLiters(double value) {
        return new Volume(value, VolumeUnits.HECTOLITRE);
    }

    public static Volume ofMilliLiters(double value) {
        return new Volume(value, VolumeUnits.MILLILITRE);
    }

    public static Volume ofOunces(double value) {
        return new Volume(value, VolumeUnits.OUNCE);
    }

    public static Volume ofPints(double value) {
        return new Volume(value, VolumeUnits.PINT);
    }

    public static Volume ofGallons(double value) {
        return new Volume(value, VolumeUnits.GALLON);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public VolumeUnit getUnitType() {
        return this.unitType;
    }

    public Volume toBaseUnit() {
        double valueInCubicMeter = this.unitType.toValueInBaseUnit(this.value);
        return Volume.of(valueInCubicMeter, VolumeUnits.CUBIC_METER);
    }

    public Volume toUnit(VolumeUnit targetUnit) {
        double valueInCubicMeter = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInCubicMeter);
        return Volume.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Volume withValue(double value) {
        return Volume.of(value, this.unitType);
    }

    public Volume toCubicMeter() {
        return this.toUnit(VolumeUnits.CUBIC_METER);
    }

    public Volume toLiter() {
        return this.toUnit(VolumeUnits.LITER);
    }

    public Volume toCubicCentimeter() {
        return this.toUnit(VolumeUnits.CUBIC_CENTIMETER);
    }

    public Volume toHectoLiter() {
        return this.toUnit(VolumeUnits.HECTOLITRE);
    }

    public Volume toMilliLiter() {
        return this.toUnit(VolumeUnits.MILLILITRE);
    }

    public Volume toOunce() {
        return this.toUnit(VolumeUnits.OUNCE);
    }

    public Volume toPint() {
        return this.toUnit(VolumeUnits.PINT);
    }

    public Volume toGallon() {
        return this.toUnit(VolumeUnits.GALLON);
    }

    public double getInCubicMeters() {
        return this.getInUnit(VolumeUnits.CUBIC_METER);
    }

    public double getInLiters() {
        return this.getInUnit(VolumeUnits.LITER);
    }

    public double getInCubicCentimeters() {
        return this.getInUnit(VolumeUnits.CUBIC_CENTIMETER);
    }

    public double getInHectoLiters() {
        return this.getInUnit(VolumeUnits.HECTOLITRE);
    }

    public double getInMilliLiters() {
        return this.getInUnit(VolumeUnits.MILLILITRE);
    }

    public double getInOunces() {
        return this.getInUnit(VolumeUnits.OUNCE);
    }

    public double getInPints() {
        return this.getInUnit(VolumeUnits.PINT);
    }

    public double getInGallons() {
        return this.getInUnit(VolumeUnits.GALLON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Volume inputQuantity = (Volume)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Volume{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

