/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.common;

import com.synerset.unitility.unitsystem.common.VolumeUnit;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum VolumeUnits implements VolumeUnit
{
    CUBIC_METER("m\u00b3", val -> val, val -> val),
    CUBIC_CENTIMETER("cm\u00b3", val -> val * 0.001, val -> val * 1000.0),
    LITER("l", val -> val * 0.001, val -> val * 1000.0),
    HECTOLITRE("hl", val -> val * 0.1, val -> val * 10.0),
    MILLILITRE("ml", val -> val * 1.0E-4, val -> val * 10000.0),
    OUNCE("fl.oz", val -> val * 2.95735295625E-5, val -> val / 2.95735295625E-5),
    PINT("pt", val -> val * 4.73176473E-4, val -> val / 4.73176473E-4),
    GALLON("gal", val -> val * 0.003785411784, val -> val / 0.003785411784);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private VolumeUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public VolumeUnit getBaseUnit() {
        return CUBIC_METER;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static VolumeUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return VolumeUnits.getDefaultUnit();
        }
        String requestedSymbol = VolumeUnits.unifySymbol(rawSymbol);
        for (VolumeUnits unit : VolumeUnits.values()) {
            String currentSymbol = VolumeUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + VolumeUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().unifyAerialAndVol().toString();
    }

    public static VolumeUnit getDefaultUnit() {
        return CUBIC_METER;
    }
}

