/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.dimensionless;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.dimensionless.BypassFactorUnit;
import com.synerset.unitility.unitsystem.dimensionless.BypassFactorUnits;
import java.util.Objects;

public class BypassFactor
implements CalculableQuantity<BypassFactorUnit, BypassFactor> {
    public static final BypassFactor BYPASS_MIN_VALUE = BypassFactor.of(0.0);
    public static final BypassFactor BYPASS_MAX_VALUE = BypassFactor.of(1.0);
    private final double value;
    private final double baseValue;
    private final BypassFactorUnit unitType;

    public BypassFactor(double value) {
        this.value = value;
        this.unitType = BypassFactorUnits.DIMENSIONLESS;
        this.baseValue = this.unitType.toValueInBaseUnit(value);
    }

    public static BypassFactor of(double value) {
        return new BypassFactor(value);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public BypassFactorUnit getUnitType() {
        return this.unitType;
    }

    public BypassFactor toBaseUnit() {
        return this;
    }

    public BypassFactor toUnit(BypassFactorUnit targetUnit) {
        return this;
    }

    @Override
    public BypassFactor withValue(double value) {
        return BypassFactor.of(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BypassFactor that = (BypassFactor)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public String toString() {
        return "BypassFactor{" + this.value + " " + this.unitType.getSymbol() + "}";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

