/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.dimensionless;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.dimensionless.GrashofNumberUnit;
import com.synerset.unitility.unitsystem.dimensionless.GrashofNumberUnits;
import java.util.Objects;

public class GrashofNumber
implements CalculableQuantity<GrashofNumberUnit, GrashofNumber> {
    private final double value;
    private final double baseValue;
    private final GrashofNumberUnit unitType;

    public GrashofNumber(double value) {
        this.value = value;
        this.unitType = GrashofNumberUnits.DIMENSIONLESS;
        this.baseValue = this.unitType.toValueInBaseUnit(value);
    }

    public static GrashofNumber of(double value) {
        return new GrashofNumber(value);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public GrashofNumberUnit getUnitType() {
        return this.unitType;
    }

    public GrashofNumber toBaseUnit() {
        return this;
    }

    public GrashofNumber toUnit(GrashofNumberUnit targetUnit) {
        return this;
    }

    @Override
    public GrashofNumber withValue(double value) {
        return GrashofNumber.of(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrashofNumber that = (GrashofNumber)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public String toString() {
        return "GrashofNumber{" + this.value + " " + this.unitType.getSymbol() + "}";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

