/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.dimensionless;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.dimensionless.PrandtlNumberUnit;
import com.synerset.unitility.unitsystem.dimensionless.PrandtlNumberUnits;
import java.util.Objects;

public class PrandtlNumber
implements CalculableQuantity<PrandtlNumberUnit, PrandtlNumber> {
    private final double value;
    private final double baseValue;
    private final PrandtlNumberUnits unitType;

    public PrandtlNumber(double value) {
        this.value = value;
        this.unitType = PrandtlNumberUnits.DIMENSIONLESS;
        this.baseValue = this.unitType.toValueInBaseUnit(value);
    }

    public static PrandtlNumber of(double value) {
        return new PrandtlNumber(value);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public PrandtlNumberUnit getUnitType() {
        return this.unitType;
    }

    public PrandtlNumber toBaseUnit() {
        return this;
    }

    public PrandtlNumber toUnit(PrandtlNumberUnit targetUnit) {
        return this;
    }

    @Override
    public PrandtlNumber withValue(double value) {
        return PrandtlNumber.of(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrandtlNumber that = (PrandtlNumber)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public String toString() {
        return "PrandtlNumber{" + this.value + " " + this.unitType.getSymbol() + "}";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

