/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.dimensionless;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.dimensionless.ReynoldsNumberUnit;
import com.synerset.unitility.unitsystem.dimensionless.ReynoldsNumberUnits;
import java.util.Objects;

public class ReynoldsNumber
implements CalculableQuantity<ReynoldsNumberUnit, ReynoldsNumber> {
    public static final ReynoldsNumber PIPE_TURBULENT_THRESHOLD = ReynoldsNumber.of(2300.0);
    public static final ReynoldsNumber PLATE_TURBULENT_THRESHOLD = ReynoldsNumber.of(5000000.0);
    public static final ReynoldsNumber AERO_TURBULENT_THRESHOLD = ReynoldsNumber.of(2.0E7);
    private final double value;
    private final double baseValue;
    private final ReynoldsNumberUnit unitType;

    public ReynoldsNumber(double value) {
        this.value = value;
        this.unitType = ReynoldsNumberUnits.DIMENSIONLESS;
        this.baseValue = this.unitType.toValueInBaseUnit(value);
    }

    public static ReynoldsNumber of(double value) {
        return new ReynoldsNumber(value);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public ReynoldsNumberUnit getUnitType() {
        return this.unitType;
    }

    public ReynoldsNumber toBaseUnit() {
        return this;
    }

    public ReynoldsNumber toUnit(ReynoldsNumberUnit targetUnit) {
        return this;
    }

    @Override
    public ReynoldsNumber withValue(double value) {
        return ReynoldsNumber.of(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReynoldsNumber that = (ReynoldsNumber)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public String toString() {
        return "ReynoldsNumber{" + this.value + " " + this.unitType.getSymbol() + "}";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

