/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.flow;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.flow.MassFlowUnit;
import com.synerset.unitility.unitsystem.flow.MassFlowUnits;
import java.util.Objects;

public class MassFlow
implements CalculableQuantity<MassFlowUnit, MassFlow> {
    public static final MassFlow MASS_FLOW_MIN_LIMIT = MassFlow.ofKilogramsPerSecond(0.0);
    private final double value;
    private final double baseValue;
    private final MassFlowUnit unitType;

    public MassFlow(double value, MassFlowUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = MassFlowUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static MassFlow of(double value, MassFlowUnit unit) {
        return new MassFlow(value, unit);
    }

    public static MassFlow of(double value, String unitSymbol) {
        MassFlowUnit resolvedUnit = MassFlowUnits.fromSymbol(unitSymbol);
        return new MassFlow(value, resolvedUnit);
    }

    public static MassFlow ofKilogramsPerSecond(double value) {
        return new MassFlow(value, MassFlowUnits.KILOGRAM_PER_SECOND);
    }

    public static MassFlow ofKilogramsPerHour(double value) {
        return new MassFlow(value, MassFlowUnits.KILOGRAM_PER_HOUR);
    }

    public static MassFlow ofTonnesPerHour(double value) {
        return new MassFlow(value, MassFlowUnits.TONNE_PER_HOUR);
    }

    public static MassFlow ofPoundsPerSecond(double value) {
        return new MassFlow(value, MassFlowUnits.POUND_PER_SECOND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public MassFlowUnit getUnitType() {
        return this.unitType;
    }

    public MassFlow toBaseUnit() {
        double valueInKilogramsPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return MassFlow.of(valueInKilogramsPerSecond, MassFlowUnits.KILOGRAM_PER_SECOND);
    }

    public MassFlow toUnit(MassFlowUnit targetUnit) {
        double valueInKilogramsPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKilogramsPerSecond);
        return MassFlow.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public MassFlow withValue(double value) {
        return MassFlow.of(value, this.unitType);
    }

    public MassFlow toKilogramsPerSecond() {
        return this.toUnit(MassFlowUnits.KILOGRAM_PER_SECOND);
    }

    public MassFlow toKiloGramPerHour() {
        return this.toUnit(MassFlowUnits.KILOGRAM_PER_HOUR);
    }

    public MassFlow toTonnesPerHour() {
        return this.toUnit(MassFlowUnits.TONNE_PER_HOUR);
    }

    public MassFlow toPoundsPerSecond() {
        return this.toUnit(MassFlowUnits.POUND_PER_SECOND);
    }

    public double getInKilogramsPerSecond() {
        return this.getInUnit(MassFlowUnits.KILOGRAM_PER_SECOND);
    }

    public double getInKiloGramsPerHour() {
        return this.getInUnit(MassFlowUnits.KILOGRAM_PER_HOUR);
    }

    public double getInTonnesPerHour() {
        return this.getInUnit(MassFlowUnits.TONNE_PER_HOUR);
    }

    public double getInPoundsPerSecond() {
        return this.getInUnit(MassFlowUnits.POUND_PER_SECOND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MassFlow inputQuantity = (MassFlow)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "MassFlow{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

