/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.flow;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.flow.VolumetricFlowUnit;
import com.synerset.unitility.unitsystem.flow.VolumetricFlowUnits;
import java.util.Objects;

public class VolumetricFlow
implements CalculableQuantity<VolumetricFlowUnit, VolumetricFlow> {
    public static final VolumetricFlow VOL_FLOW_MIN_LIMIT = VolumetricFlow.ofCubicMetersPerSecond(0.0);
    private final double value;
    private final double baseValue;
    private final VolumetricFlowUnit unitType;

    public VolumetricFlow(double value, VolumetricFlowUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = VolumetricFlowUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static VolumetricFlow of(double value, VolumetricFlowUnit unit) {
        return new VolumetricFlow(value, unit);
    }

    public static VolumetricFlow of(double value, String unitSymbol) {
        VolumetricFlowUnit resolvedUnit = VolumetricFlowUnits.fromSymbol(unitSymbol);
        return new VolumetricFlow(value, resolvedUnit);
    }

    public static VolumetricFlow ofCubicMetersPerSecond(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.CUBIC_METERS_PER_SECOND);
    }

    public static VolumetricFlow ofCubicMetersPerMinute(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.CUBIC_METERS_PER_MINUTE);
    }

    public static VolumetricFlow ofCubicMetersPerHour(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.CUBIC_METERS_PER_HOUR);
    }

    public static VolumetricFlow ofCubicFeetPerMinute(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.CUBIC_FEET_PER_MINUTE);
    }

    public static VolumetricFlow ofLitresPerSecond(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.LITRE_PER_SECOND);
    }

    public static VolumetricFlow ofLitresPerMinute(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.LITRE_PER_MINUTE);
    }

    public static VolumetricFlow ofLitresPerHour(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.LITRE_PER_HOUR);
    }

    public static VolumetricFlow ofGallonsPerSecond(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.GALLONS_PER_SECOND);
    }

    public static VolumetricFlow ofGallonsPerMinute(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.GALLONS_PER_MINUTE);
    }

    public static VolumetricFlow ofGallonsPerHour(double value) {
        return new VolumetricFlow(value, VolumetricFlowUnits.GALLONS_PER_HOUR);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public VolumetricFlowUnit getUnitType() {
        return this.unitType;
    }

    public VolumetricFlow toBaseUnit() {
        double valueInCubicMetersPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return VolumetricFlow.of(valueInCubicMetersPerSecond, VolumetricFlowUnits.CUBIC_METERS_PER_SECOND);
    }

    public VolumetricFlow toUnit(VolumetricFlowUnit targetUnit) {
        double valueInCubicMetersPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInCubicMetersPerSecond);
        return VolumetricFlow.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public VolumetricFlow withValue(double value) {
        return VolumetricFlow.of(value, this.unitType);
    }

    public VolumetricFlow toCubicMetersPerSecond() {
        return this.toUnit(VolumetricFlowUnits.CUBIC_METERS_PER_SECOND);
    }

    public VolumetricFlow toCubicMetersPerMinute() {
        return this.toUnit(VolumetricFlowUnits.CUBIC_METERS_PER_MINUTE);
    }

    public VolumetricFlow toCubicMetersPerHour() {
        return this.toUnit(VolumetricFlowUnits.CUBIC_METERS_PER_HOUR);
    }

    public VolumetricFlow toCubicFeetPerMinute() {
        return this.toUnit(VolumetricFlowUnits.CUBIC_FEET_PER_MINUTE);
    }

    public VolumetricFlow toLitresPerSecond() {
        return this.toUnit(VolumetricFlowUnits.LITRE_PER_SECOND);
    }

    public VolumetricFlow toLitresPerMinute() {
        return this.toUnit(VolumetricFlowUnits.LITRE_PER_MINUTE);
    }

    public VolumetricFlow toLitresPerHour() {
        return this.toUnit(VolumetricFlowUnits.LITRE_PER_HOUR);
    }

    public VolumetricFlow toGallonsPerSecond() {
        return this.toUnit(VolumetricFlowUnits.GALLONS_PER_SECOND);
    }

    public VolumetricFlow toGallonsPerMinute() {
        return this.toUnit(VolumetricFlowUnits.GALLONS_PER_MINUTE);
    }

    public VolumetricFlow toGallonsPerHour() {
        return this.toUnit(VolumetricFlowUnits.GALLONS_PER_HOUR);
    }

    public double getInCubicMetersPerSecond() {
        return this.getInUnit(VolumetricFlowUnits.CUBIC_METERS_PER_SECOND);
    }

    public double getInCubicMetersPerMinute() {
        return this.getInUnit(VolumetricFlowUnits.CUBIC_METERS_PER_MINUTE);
    }

    public double getInCubicMetersPerHour() {
        return this.getInUnit(VolumetricFlowUnits.CUBIC_METERS_PER_HOUR);
    }

    public double getInCubicFeetPerMinute() {
        return this.getInUnit(VolumetricFlowUnits.CUBIC_FEET_PER_MINUTE);
    }

    public double getInLitresPerSecond() {
        return this.getInUnit(VolumetricFlowUnits.LITRE_PER_SECOND);
    }

    public double getInLitresPerMinute() {
        return this.getInUnit(VolumetricFlowUnits.LITRE_PER_MINUTE);
    }

    public double getInLitresPerHour() {
        return this.getInUnit(VolumetricFlowUnits.LITRE_PER_HOUR);
    }

    public double getInGallonsPerSecond() {
        return this.getInUnit(VolumetricFlowUnits.GALLONS_PER_SECOND);
    }

    public double getInGallonsPerMinute() {
        return this.getInUnit(VolumetricFlowUnits.GALLONS_PER_MINUTE);
    }

    public double getInGallonsPerHour() {
        return this.getInUnit(VolumetricFlowUnits.GALLONS_PER_HOUR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumetricFlow inputQuantity = (VolumetricFlow)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "VolumetricFlow{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

