/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.geographic.Latitude;
import com.synerset.unitility.unitsystem.geographic.Longitude;
import com.synerset.unitility.unitsystem.util.ValueFormatter;

class DMSValueFormatter {
    private DMSValueFormatter() {
        throw new IllegalStateException("Utility class");
    }

    static String latitudeToDmsFormat(Latitude latitude, int relevantDigits) {
        double latitudeInDegrees = latitude.getInDegrees();
        char directionSymbol = latitudeInDegrees < 0.0 ? (char)'S' : 'N';
        return DMSValueFormatter.createDMSNotation(latitudeInDegrees, directionSymbol, relevantDigits);
    }

    static String longitudeToDmsFormat(Longitude longitude, int relevantDigits) {
        double longitudeInDegrees = longitude.getInDegrees();
        char directionSymbol = longitudeInDegrees < 0.0 ? (char)'W' : 'E';
        return DMSValueFormatter.createDMSNotation(longitudeInDegrees, directionSymbol, relevantDigits);
    }

    private static String createDMSNotation(double coordinateInDegrees, char directionSymbol, int relevantDigits) {
        coordinateInDegrees = Math.abs(coordinateInDegrees);
        int degrees = (int)coordinateInDegrees;
        double minutesAndSeconds = (coordinateInDegrees - (double)degrees) * 60.0;
        int minutes = (int)minutesAndSeconds;
        double seconds = (minutesAndSeconds - (double)minutes) * 60.0;
        String secondsWithRelDigits = relevantDigits > 0 ? ValueFormatter.toStringWithRelevantDigits(seconds, relevantDigits) : String.valueOf(seconds);
        return String.format("%d\u00b0%d'%s\"%c", degrees, minutes, secondsWithRelDigits, Character.valueOf(directionSymbol));
    }
}

