/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemArgumentException;
import com.synerset.unitility.unitsystem.geographic.Latitude;
import com.synerset.unitility.unitsystem.geographic.Longitude;
import com.synerset.unitility.unitsystem.util.ValueFormatter;
import java.util.Objects;

public record GeoCoordinate(Latitude latitude, Longitude longitude, String name) {
    public GeoCoordinate(Latitude latitude, Longitude longitude, String name) {
        this.validateLatitude(latitude);
        this.validateLongitude(longitude);
        this.latitude = latitude;
        this.longitude = longitude;
        this.name = name;
    }

    public static GeoCoordinate of(Latitude latitude, Longitude longitude, String name) {
        return new GeoCoordinate(latitude, longitude, name);
    }

    public static GeoCoordinate of(Latitude latitude, Longitude longitude) {
        return new GeoCoordinate(latitude, longitude, null);
    }

    public String toDMSFormat() {
        return this.latitude.toDMSFormat() + ", " + this.longitude.toDMSFormat();
    }

    public String toDMSFormat(String variableName) {
        return variableName + " = " + this.toDMSFormat();
    }

    public String toDMSFormat(int relevantDigits) {
        return this.latitude.toDMSFormat(relevantDigits) + ", " + this.longitude.toDMSFormat(relevantDigits);
    }

    public String toDMSFormat(String variableName, int relevantDigits) {
        return variableName + " = " + this.toDMSFormat(relevantDigits);
    }

    public String toDecimalDegrees() {
        return this.latitude.getInDegrees() + ", " + this.longitude.getInDegrees();
    }

    public String toDecimalDegrees(String variableName) {
        return variableName + " = " + this.toDecimalDegrees();
    }

    public String toDecimalDegrees(int relevantDigits) {
        return ValueFormatter.toStringWithRelevantDigits(this.latitude.getInDegrees(), relevantDigits) + ", " + ValueFormatter.toStringWithRelevantDigits(this.longitude.getInDegrees(), relevantDigits);
    }

    public String toDecimalDegrees(String variableName, int relevantDigits) {
        return variableName + " = " + this.toDecimalDegrees(relevantDigits);
    }

    public String toEngineeringFormat() {
        return this.latitude.toEngineeringFormat() + ", " + this.longitude.toEngineeringFormat();
    }

    public String toEngineeringFormat(String variableName) {
        return variableName + " = " + this.toEngineeringFormat();
    }

    public String toEngineeringFormat(int relevantDigits) {
        return this.latitude.toEngineeringFormat(relevantDigits) + ", " + this.longitude.toEngineeringFormat(relevantDigits);
    }

    public String toEngineeringFormat(String variableName, int relevantDigits) {
        return variableName + " = " + this.toEngineeringFormat(relevantDigits);
    }

    private void validateLatitude(Latitude latitude) {
        if (latitude.isGreaterThan(Latitude.MAX_EARTH_LATITUDE) || latitude.isLowerThan(Latitude.MIN_EARTH_LATITUDE)) {
            throw new UnitSystemArgumentException("Invalid latitude value = " + latitude + " Allowed range: " + Latitude.MIN_EARTH_LATITUDE.toEngineeringFormat() + " to " + Latitude.MAX_EARTH_LATITUDE.toEngineeringFormat());
        }
    }

    private void validateLongitude(Longitude longitude) {
        if (longitude.isGreaterThan(Longitude.MAX_EARTH_LONGITUDE) || longitude.isLowerThan(Longitude.MIN_EARTH_LONGITUDE)) {
            throw new UnitSystemArgumentException("Invalid longitude value = " + longitude + ". Allowed range: " + Longitude.MIN_EARTH_LONGITUDE.toEngineeringFormat() + " to " + Longitude.MAX_EARTH_LONGITUDE.toEngineeringFormat());
        }
    }

    public boolean equalsWithPrecision(GeoCoordinate inputGeoCoordinate, double epsilon) {
        if (this == inputGeoCoordinate) {
            return true;
        }
        if (inputGeoCoordinate == null) {
            return false;
        }
        return this.latitude.isEqualWithPrecision(inputGeoCoordinate.latitude, epsilon) && this.longitude.isEqualWithPrecision(inputGeoCoordinate.longitude, epsilon);
    }

    public GeoCoordinate toBaseUnit() {
        return GeoCoordinate.of(this.latitude.toBaseUnit(), this.longitude.toBaseUnit());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoCoordinate that = (GeoCoordinate)o;
        return Objects.equals(this.latitude.toBaseUnit(), that.latitude.toBaseUnit()) && Objects.equals(this.longitude.toBaseUnit(), that.longitude.toBaseUnit()) && Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.latitude.toBaseUnit(), this.longitude.toBaseUnit(), this.name);
    }
}

