/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.common.Angle;
import com.synerset.unitility.unitsystem.common.Distance;
import com.synerset.unitility.unitsystem.geographic.GeoCoordinate;
import com.synerset.unitility.unitsystem.geographic.Latitude;
import com.synerset.unitility.unitsystem.geographic.Longitude;

public class HaversineEquations {
    static final Distance MEAN_EARTH_RADIUS = Distance.ofMeters(6371000.0);

    private HaversineEquations() {
        throw new IllegalStateException("Utility class");
    }

    static Angle calcBearing(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        double lat1 = startCoordinate.latitude().getInRadians();
        double lat2 = targetCoordinate.latitude().getInRadians();
        double lon1 = startCoordinate.longitude().getInDegrees();
        double lon2 = targetCoordinate.longitude().getInDegrees();
        double deltaLon = Math.toRadians(lon2 - lon1);
        double y = Math.sin(deltaLon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        double bearing = Math.atan2(y, x);
        bearing = Math.toDegrees(bearing);
        return Angle.ofDegrees(bearing %= 180.0);
    }

    static Distance calcSphericalDistance(GeoCoordinate startCoordinate, GeoCoordinate targetCoordinate) {
        double dLat = ((Latitude)targetCoordinate.latitude().toDegrees().minus(startCoordinate.latitude())).getInRadians();
        double dLon = ((Longitude)targetCoordinate.longitude().toDegrees().minus(startCoordinate.longitude())).getInRadians();
        double havLat = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0);
        double havLon = Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double lat1 = startCoordinate.latitude().getInRadians();
        double lat2 = targetCoordinate.latitude().getInRadians();
        double a = havLat + Math.cos(lat1) * Math.cos(lat2) * havLon;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return (Distance)MEAN_EARTH_RADIUS.multiply(c);
    }

    static GeoCoordinate calcTargetCoordinate(GeoCoordinate fromCoordinate, Angle bearing, Distance distanceChange) {
        double distanceByEarthRadius = distanceChange.toMeter().div(MEAN_EARTH_RADIUS);
        double lat1 = fromCoordinate.latitude().getInRadians();
        double lon1 = fromCoordinate.longitude().getInRadians();
        double trueBearing = bearing.getInRadians();
        double newLat = Math.asin(Math.sin(lat1) * Math.cos(distanceByEarthRadius) + Math.cos(lat1) * Math.sin(distanceByEarthRadius) * Math.cos(trueBearing));
        double newLon = lon1 + Math.atan2(Math.sin(trueBearing) * Math.sin(distanceByEarthRadius) * Math.cos(lat1), Math.cos(distanceByEarthRadius) - Math.sin(lat1) * Math.sin(newLat));
        double latInDegrees = Math.toDegrees(newLat);
        double lonInDegrees = Math.toDegrees(newLon);
        lonInDegrees = lonInDegrees < -180.0 ? 180.0 - Math.abs(lonInDegrees) % 180.0 : (lonInDegrees > 180.0 ? (180.0 - Math.abs(lonInDegrees) % 180.0) * -1.0 : (lonInDegrees %= 180.0));
        return GeoCoordinate.of(Latitude.ofDegrees(latInDegrees %= 90.0), Longitude.ofDegrees(lonInDegrees));
    }

    public static double dmsToDegrees(double degrees, double minutes, double seconds) {
        return Math.abs(degrees) + Math.abs(minutes) / 60.0 + Math.abs(seconds) / 3600.0;
    }

    public static double determineSign(char directionChar, double degrees) {
        double sign = 1.0;
        if (directionChar == 'S' || directionChar == 's' || directionChar == 'W' || directionChar == 'w' || degrees < 0.0) {
            sign = -1.0;
        }
        return sign;
    }
}

