/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.geographic;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.common.AngleUnit;
import com.synerset.unitility.unitsystem.common.AngleUnits;
import com.synerset.unitility.unitsystem.geographic.CardinalDirection;
import com.synerset.unitility.unitsystem.geographic.DMSValueFormatter;
import com.synerset.unitility.unitsystem.geographic.HaversineEquations;
import java.util.Objects;

public class Latitude
implements CalculableQuantity<AngleUnit, Latitude> {
    public static final Latitude MIN_EARTH_LATITUDE = Latitude.ofDegrees(-90.0);
    public static final Latitude MAX_EARTH_LATITUDE = Latitude.ofDegrees(90.0);
    private final double value;
    private final double baseValue;
    private final AngleUnit unitType;

    public Latitude(double value, AngleUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = AngleUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Latitude of(double value, AngleUnit unit) {
        return new Latitude(value, unit);
    }

    public static Latitude of(double value, String unitSymbol) {
        AngleUnit resolvedUnit = AngleUnits.fromSymbol(unitSymbol);
        return new Latitude(value, resolvedUnit);
    }

    public static Latitude ofRadians(double value) {
        return new Latitude(value, AngleUnits.RADIANS);
    }

    public static Latitude ofDegrees(double value) {
        return new Latitude(value, AngleUnits.DEGREES);
    }

    public static Latitude ofDegMinSec(int degrees, int minutes, double seconds) {
        double decimalDegrees = HaversineEquations.dmsToDegrees(degrees, minutes, seconds);
        double decimalDegreesWithSign = degrees > 0 ? decimalDegrees : decimalDegrees * -1.0;
        return Latitude.ofDegrees(decimalDegreesWithSign);
    }

    public static Latitude ofDegMinSec(int degrees, int minutes, double seconds, CardinalDirection direction) {
        double sign = HaversineEquations.determineSign(direction.getDirectionChar(), degrees);
        double decimalDegrees = HaversineEquations.dmsToDegrees(degrees, minutes, seconds);
        return Latitude.ofDegrees(sign * decimalDegrees);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public AngleUnit getUnitType() {
        return this.unitType;
    }

    public Latitude toBaseUnit() {
        double degrees = this.unitType.toValueInBaseUnit(this.value);
        return Latitude.of(degrees, AngleUnits.DEGREES);
    }

    public Latitude toUnit(AngleUnit targetUnit) {
        double valueInDegrees = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInDegrees);
        return Latitude.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Latitude withValue(double value) {
        return Latitude.of(value, this.unitType);
    }

    public Latitude toRadians() {
        return this.toUnit(AngleUnits.RADIANS);
    }

    public Latitude toDegrees() {
        return this.toUnit(AngleUnits.DEGREES);
    }

    public double getInRadians() {
        return this.getInUnit(AngleUnits.RADIANS);
    }

    public double getInDegrees() {
        return this.getInUnit(AngleUnits.DEGREES);
    }

    public String toDMSFormat() {
        return DMSValueFormatter.latitudeToDmsFormat(this, -1);
    }

    public String toDMSFormat(String variableName) {
        return variableName + " = " + this.toDMSFormat();
    }

    public String toDMSFormat(int relevantDigits) {
        return DMSValueFormatter.latitudeToDmsFormat(this, relevantDigits);
    }

    public String toDMSFormat(String variableName, int relevantDigits) {
        return variableName + " = " + this.toDMSFormat(relevantDigits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Latitude inputQuantity = (Latitude)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        String separator = this.getUnitType().getSymbol().contains("\u00b0") ? "" : " ";
        return "Latitude{" + this.value + separator + this.unitType.getSymbol() + "}";
    }
}

