/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.humidity;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.humidity.RelativeHumidityUnit;
import com.synerset.unitility.unitsystem.humidity.RelativeHumidityUnits;
import java.util.Objects;

public class RelativeHumidity
implements CalculableQuantity<RelativeHumidityUnit, RelativeHumidity> {
    public static final RelativeHumidity RH_MIN_LIMIT = RelativeHumidity.ofPercentage(0.0);
    public static final RelativeHumidity RH_MAX_LIMIT = RelativeHumidity.ofPercentage(100.0);
    private final double value;
    private final double baseValue;
    private final RelativeHumidityUnit unitType;

    public RelativeHumidity(double value, RelativeHumidityUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = RelativeHumidityUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static RelativeHumidity of(double value, RelativeHumidityUnit unit) {
        return new RelativeHumidity(value, unit);
    }

    public static RelativeHumidity of(double value, String unitSymbol) {
        RelativeHumidityUnit resolvedUnit = RelativeHumidityUnits.fromSymbol(unitSymbol);
        return new RelativeHumidity(value, resolvedUnit);
    }

    public static RelativeHumidity ofPercentage(double value) {
        return new RelativeHumidity(value, RelativeHumidityUnits.PERCENT);
    }

    public static RelativeHumidity ofDecimal(double value) {
        return new RelativeHumidity(value, RelativeHumidityUnits.DECIMAL);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public RelativeHumidityUnit getUnitType() {
        return this.unitType;
    }

    public RelativeHumidity toBaseUnit() {
        double valueInPascal = this.unitType.toValueInBaseUnit(this.value);
        return RelativeHumidity.of(valueInPascal, RelativeHumidityUnits.PERCENT);
    }

    public RelativeHumidity toUnit(RelativeHumidityUnit targetUnit) {
        double valueInPascal = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInPascal);
        return RelativeHumidity.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public RelativeHumidity withValue(double value) {
        return RelativeHumidity.of(value, this.unitType);
    }

    public RelativeHumidity toPercent() {
        return this.toUnit(RelativeHumidityUnits.PERCENT);
    }

    public RelativeHumidity toDecimal() {
        return this.toUnit(RelativeHumidityUnits.DECIMAL);
    }

    public double getInPercent() {
        return this.getInUnit(RelativeHumidityUnits.PERCENT);
    }

    public double getInDecimal() {
        return this.getInUnit(RelativeHumidityUnits.DECIMAL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeHumidity inputQuantity = (RelativeHumidity)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "RelativeHumidity{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

