/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.mechanical.ForceUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum ForceUnits implements ForceUnit
{
    NEWTON("N", val -> val, val -> val),
    KILONEWTON("kN", val -> val * 1000.0, val -> val / 1000.0),
    KILOPOND("kp", val -> val * 9.80665, val -> val / 9.80665),
    DYNE("dyn", val -> val * 1.0E-5, val -> val / 1.0E-5),
    POUND_FORCE("lbf", val -> val * 4.4482216152605, val -> val / 4.4482216152605),
    POUNDAL("pdl", val -> val * 0.138254954376, val -> val / 0.138254954376);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private ForceUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public ForceUnit getBaseUnit() {
        return NEWTON;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static ForceUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return ForceUnits.getDefaultUnit();
        }
        String requestedSymbol = ForceUnits.unifySymbol(rawSymbol);
        for (ForceUnits unit : ForceUnits.values()) {
            String currentSymbol = ForceUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + ForceUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().toString();
    }

    public static ForceUnit getDefaultUnit() {
        return NEWTON;
    }
}

