/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.CalculableQuantity;
import com.synerset.unitility.unitsystem.mechanical.MomentumUnit;
import com.synerset.unitility.unitsystem.mechanical.MomentumUnits;
import java.util.Objects;

public class Momentum
implements CalculableQuantity<MomentumUnit, Momentum> {
    private final double value;
    private final double baseValue;
    private final MomentumUnit unitType;

    public Momentum(double value, MomentumUnit unitType) {
        this.value = value;
        if (unitType == null) {
            unitType = MomentumUnits.getDefaultUnit();
        }
        this.unitType = unitType;
        this.baseValue = unitType.toValueInBaseUnit(value);
    }

    public static Momentum of(double value, MomentumUnit unit) {
        return new Momentum(value, unit);
    }

    public static Momentum of(double value, String unitSymbol) {
        MomentumUnit resolvedUnit = MomentumUnits.fromSymbol(unitSymbol);
        return new Momentum(value, resolvedUnit);
    }

    public static Momentum ofKilogramMeterPerSecond(double value) {
        return new Momentum(value, MomentumUnits.KILOGRAM_METER_PER_SECOND);
    }

    public static Momentum ofPoundFeetPerSecond(double value) {
        return new Momentum(value, MomentumUnits.POUND_FEET_PER_SECOND);
    }

    public static Momentum ofGramCentimetrePerSecond(double value) {
        return new Momentum(value, MomentumUnits.GRAM_CENTIMETRE_PER_SECOND);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public MomentumUnit getUnitType() {
        return this.unitType;
    }

    public Momentum toBaseUnit() {
        double valueInKilogramMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        return Momentum.of(valueInKilogramMeterPerSecond, MomentumUnits.KILOGRAM_METER_PER_SECOND);
    }

    public Momentum toUnit(MomentumUnit targetUnit) {
        double valueInKilogramMeterPerSecond = this.unitType.toValueInBaseUnit(this.value);
        double valueInTargetUnit = targetUnit.fromValueInBaseUnit(valueInKilogramMeterPerSecond);
        return Momentum.of(valueInTargetUnit, targetUnit);
    }

    @Override
    public Momentum withValue(double value) {
        return Momentum.of(value, this.unitType);
    }

    public Momentum toKilogramMeterPerSecond() {
        return this.toUnit(MomentumUnits.KILOGRAM_METER_PER_SECOND);
    }

    public Momentum toPoundFeetPerSecond() {
        return this.toUnit(MomentumUnits.POUND_FEET_PER_SECOND);
    }

    public Momentum toGramCentimetrePerSecond() {
        return this.toUnit(MomentumUnits.GRAM_CENTIMETRE_PER_SECOND);
    }

    public double getInKilogramMetersPerSecond() {
        return this.getInUnit(MomentumUnits.KILOGRAM_METER_PER_SECOND);
    }

    public double getInPoundFeetPerSecond() {
        return this.getInUnit(MomentumUnits.POUND_FEET_PER_SECOND);
    }

    public double getInGramCentimetersPerSecond() {
        return this.getInUnit(MomentumUnits.GRAM_CENTIMETRE_PER_SECOND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Momentum inputQuantity = (Momentum)o;
        return Double.compare(inputQuantity.toBaseUnit().getValue(), this.baseValue) == 0 && Objects.equals(this.unitType.getBaseUnit(), inputQuantity.getUnitType().getBaseUnit());
    }

    public int hashCode() {
        return Objects.hash(this.baseValue, this.unitType.getBaseUnit());
    }

    public String toString() {
        return "Momentum{" + this.value + " " + this.unitType.getSymbol() + "}";
    }
}

