/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem.mechanical;

import com.synerset.unitility.unitsystem.exceptions.UnitSystemParseException;
import com.synerset.unitility.unitsystem.mechanical.MomentumUnit;
import com.synerset.unitility.unitsystem.util.StringTransformer;
import java.util.function.DoubleUnaryOperator;

public enum MomentumUnits implements MomentumUnit
{
    KILOGRAM_METER_PER_SECOND("kg\u00b7m/s", val -> val, val -> val),
    POUND_FEET_PER_SECOND("lb\u00b7ft/s", val -> val * 0.138254954376, val -> val / 0.138254954376),
    GRAM_CENTIMETRE_PER_SECOND("g\u00b7cm/s", val -> val * 1.0E-5, val -> val / 1.0E-5);

    private final String symbol;
    private final DoubleUnaryOperator toBaseConverter;
    private final DoubleUnaryOperator fromBaseToUnitConverter;

    private MomentumUnits(String symbol, DoubleUnaryOperator toBaseConverter, DoubleUnaryOperator fromBaseToUnitConverter) {
        this.symbol = symbol;
        this.toBaseConverter = toBaseConverter;
        this.fromBaseToUnitConverter = fromBaseToUnitConverter;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public MomentumUnits getBaseUnit() {
        return KILOGRAM_METER_PER_SECOND;
    }

    @Override
    public double toValueInBaseUnit(double valueInThisUnit) {
        return this.toBaseConverter.applyAsDouble(valueInThisUnit);
    }

    @Override
    public double fromValueInBaseUnit(double valueInBaseUnit) {
        return this.fromBaseToUnitConverter.applyAsDouble(valueInBaseUnit);
    }

    public static MomentumUnit fromSymbol(String rawSymbol) {
        if (rawSymbol == null || rawSymbol.isBlank()) {
            return MomentumUnits.getDefaultUnit();
        }
        String requestedSymbol = MomentumUnits.unifySymbol(rawSymbol);
        for (MomentumUnits unit : MomentumUnits.values()) {
            String currentSymbol = MomentumUnits.unifySymbol(unit.getSymbol());
            if (!currentSymbol.equalsIgnoreCase(requestedSymbol)) continue;
            return unit;
        }
        throw new UnitSystemParseException("Unsupported unit symbol: {" + rawSymbol + "}. Target class: " + MomentumUnits.class.getSimpleName());
    }

    private static String unifySymbol(String inputString) {
        return StringTransformer.of(inputString).trimLowerAndClean().unifyMultiAndDiv().dropParentheses().toString();
    }

    public static MomentumUnit getDefaultUnit() {
        return KILOGRAM_METER_PER_SECOND;
    }
}

